/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.LocalNativeConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.LocalNativeSourceImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.SourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.ConfigurableSource;
import com.ibm.java.diagnostics.healthcenter.sources.SourceListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class LocalNativeEnablementConfigurationSourceImpl
extends SourceImpl
implements ConfigurableSource {
    private static final String CONFIGURATION = "Configuration";
    private static final Logger TRACE = LogFactory.getTrace(LocalNativeEnablementConfigurationSourceImpl.class);
    private static final String STATE_INFO_SPLITTING_STRING = "[,\n]";
    private static final String ON_SUFFIX = "=on";
    private String configuration;
    private LocalNativeConnectionDataImpl connection;
    private LocalNativeSourceImpl source;
    private static final int SECONDS_TO_MILLIS = 1000;

    public LocalNativeEnablementConfigurationSourceImpl(String string, ConnectionDataBuilder connectionDataBuilder, LocalNativeSourceImpl localNativeSourceImpl, LocalNativeConnectionDataImpl localNativeConnectionDataImpl, String string2) {
        super(string + CONFIGURATION, connectionDataBuilder);
        this.connection = localNativeConnectionDataImpl;
        this.configuration = string2;
        this.source = localNativeSourceImpl;
    }

    @Override
    public void internalShutdown() {
        this.connection.destroyConnection();
    }

    @Override
    public InputStream getBackingStream() {
        if (this.configuration != null) {
            String string = Messages.getString("JmxSourceImpl.configuration.comment.template");
            String string2 = MessageFormat.format(string, "#Configuration saved by", this.getName());
            String string3 = string2 + "\n" + this.configuration;
            try {
                return new ByteArrayInputStream(string3.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                TRACE.fine(unsupportedEncodingException.toString());
                return new ByteArrayInputStream(string3.getBytes());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfig() {
        for (int i = 0; i < 5; ++i) {
            long l = 1000L;
            byte[] byArray = this.connection.getTopicData(this.getName());
            if (byArray != null) {
                String string;
                this.configuration = string = new String(byArray);
                String string2 = Messages.getString("JmxSourceImpl.configuration.comment.template");
                String string3 = MessageFormat.format(string2, "#Configuration saved by", this.getName());
                String string4 = string3 + "\n" + this.configuration;
                this.tellConnectionAboutDataReceived(byArray.length);
                Object object = this.listenerListLock;
                synchronized (object) {
                    Iterator iterator = this.sourceListeners.iterator();
                    if (iterator.hasNext()) {
                        SourceListener sourceListener = (SourceListener)iterator.next();
                        sourceListener.notifySourceChanged(new ByteArrayInputStream(string4.getBytes()));
                        return;
                    }
                }
            }
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    @Override
    protected void tellNewSlicerAboutExistingData(SourceListener sourceListener) {
        InputStream inputStream = this.getBackingStream();
        if (inputStream != null) {
            sourceListener.notifySourceChanged(inputStream);
        }
    }

    @Override
    public void disable(String string) {
        this.modify("off", string);
    }

    @Override
    public void disable(Collection<String> collection) {
        this.modify("off", collection.toArray(new String[0]));
    }

    public void modify(String string, String ... stringArray) {
        String string2 = string;
        String[] stringArray2 = stringArray;
        this.connection.sendMessage(this.source.getName(), string2, stringArray2);
        Thread thread = new Thread(string){

            @Override
            public void run() {
                LocalNativeEnablementConfigurationSourceImpl.this.updateConfig();
            }
        };
        thread.start();
    }

    @Override
    public void enable(String string) {
        this.modify("on", string);
    }

    @Override
    public void enable(Collection<String> collection) {
        this.modify("on", collection.toArray(new String[0]));
    }

    @Override
    public boolean isEnabled(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        Boolean bl = this.isEnabled(arrayList).get(string);
        return bl;
    }

    @Override
    public Map<String, Boolean> isEnabled(Collection<String> collection) {
        boolean bl = true;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        List<String> list = null;
        String string = this.configuration;
        if (string != null) {
            list = Arrays.asList(string.split(STATE_INFO_SPLITTING_STRING));
        } else {
            bl = false;
        }
        for (String string2 : collection) {
            boolean bl2;
            boolean bl3 = bl2 = list != null && (list.contains(string2 + ON_SUFFIX) || list.contains(string2));
            if (!bl || bl2) {
                hashMap.put(string2, true);
                continue;
            }
            hashMap.put(string2, false);
        }
        return hashMap;
    }

    @Override
    public void disable() {
    }

    @Override
    public void enable() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isSupported() {
        return this.configuration != null;
    }

    public String toString() {
        return this.getName();
    }
}

