/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceLabels;

public class TraceMetricsUtil {
    public static double getMissingDataRatio(Data data) {
        double d = 0.0;
        TwoDimensionalData twoDimensionalData = TraceMetricsUtil.getMissingTraceBytesData(data);
        TwoDimensionalData twoDimensionalData2 = TraceMetricsUtil.getParsedTraceBytesData(data);
        if (twoDimensionalData != null && twoDimensionalData2 != null) {
            double d2 = twoDimensionalData.getRawTotalY();
            double d3 = twoDimensionalData2.getRawTotalY();
            double d4 = d2 + d3;
            d = d2 / d4;
        }
        return d;
    }

    public static TwoDimensionalData getMissingTraceBytesData(Data data) {
        return TraceMetricsUtil.getTwoDimensionalData(TraceLabels.MISSING_TRACE_DATA, data);
    }

    public static TwoDimensionalData getParsedTraceBytesData(Data data) {
        return TraceMetricsUtil.getTwoDimensionalData(TraceLabels.PARSED_TRACE_DATA, data);
    }

    private static TwoDimensionalData getTwoDimensionalData(String string, Data data) {
        Data data2;
        TwoDimensionalData twoDimensionalData = null;
        if (data != null && (data2 = data.getTopLevelData(string)) instanceof TwoDimensionalData) {
            twoDimensionalData = (TwoDimensionalData)data2;
        }
        return twoDimensionalData;
    }
}

