/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.marshalling.data.events;

import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.LockingInternalEvent;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.LockingInternalObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LockingEventHandler
extends Thread {
    List<LockingInternalEvent> listeners = new ArrayList<LockingInternalEvent>();
    Queue<LockingInternalObject> events = new ConcurrentLinkedQueue<LockingInternalObject>();
    private boolean flushData = false;
    private static int eventQueueSize = 0;
    private static final int maxEventQueueSize = 15;
    protected volatile boolean run = true;

    public LockingEventHandler() {
        super("Locking Event Handler");
        this.setDaemon(true);
    }

    public void addLockingEventListener(LockingInternalEvent lockingInternalEvent) {
        this.listeners.add(lockingInternalEvent);
    }

    private void triggerLocking(LockingInternalObject lockingInternalObject) {
        for (LockingInternalEvent lockingInternalEvent : this.listeners) {
            lockingInternalEvent.lockingEvent(lockingInternalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(LockingInternalObject lockingInternalObject) {
        Queue<LockingInternalObject> queue = this.events;
        synchronized (queue) {
            if (eventQueueSize < 15 && !this.flushData) {
                this.events.add(lockingInternalObject);
                ++eventQueueSize;
            } else {
                this.flushData = true;
            }
            this.events.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                if (!this.events.isEmpty()) {
                    if (this.flushData) {
                        while (this.flushData) {
                            this.triggerLocking(this.events.poll());
                            --eventQueueSize;
                            if (!this.events.isEmpty()) continue;
                            this.flushData = false;
                        }
                    } else {
                        this.triggerLocking(this.events.poll());
                        --eventQueueSize;
                    }
                }
                Queue<LockingInternalObject> queue = this.events;
                synchronized (queue) {
                    try {
                        if (this.events.isEmpty()) {
                            this.events.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.run = false;
        this.interrupt();
    }
}

