/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.ProgramOption;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

class Threads
extends ProgramOption {
    List threads = new LinkedList();

    Threads() {
    }

    String getDescription() {
        return "A comma separated list of thread ids to include in the formatted trace output.";
    }

    String getName() {
        return "threads";
    }

    String getUsage() {
        return "-threads=id[,id]";
    }

    Object getValue() {
        return this.threads;
    }

    void setValue(String value) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(value, ",");
        String token = "";
        try {
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                Long id = token.startsWith("0x") ? Long.valueOf(token.substring(2), 16) : Long.valueOf(token);
                this.threads.add(id);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The specified thread id, \"" + token + "\" is not valid. Id's must be a number");
        }
    }

    void setDefault() {
    }
}

