/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.MissingDataException;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TracePointDebugInfo;
import com.ibm.jvm.trace.format.api.TracePointImpl;
import com.ibm.jvm.trace.format.api.TraceRecord;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TraceThread
implements Comparable {
    TraceContext context;
    BigInteger timerUpperWord = BigInteger.ZERO;
    BigInteger newestWrapTime = BigInteger.ZERO;
    long threadLostRecordCount = 0L;
    long threadRecordCount = 0L;
    protected long threadID = 0L;
    protected long nativeThreadID = 0L;
    protected String threadName = "";
    private Long threadIdentifier = null;
    protected ByteStream stream = null;
    TracePointImpl next = null;
    TracePointImpl live = null;
    ThreadIterator iterator;
    Vector records = new Vector();
    boolean userDiscardedData = false;
    List debugOffsets = new Vector();

    TraceThread(TraceContext context, long threadID, long osThreadID, String threadName) {
        this.context = context;
        this.threadName = threadName;
        this.threadID = threadID;
        this.nativeThreadID = osThreadID;
        this.threadIdentifier = threadID;
        this.stream = context.createByteStream();
    }

    public Iterator getIterator() {
        if (this.iterator == null) {
            this.iterator = new ThreadIterator(this);
        }
        return this.iterator;
    }

    private synchronized TracePointImpl getNextRegularTracepoint() throws MissingDataException {
        long upperWord = 0L;
        TracePointImpl tracepoint = null;
        try {
            if (this.stream != null) {
                tracepoint = new TracePointImpl(this.context, this.stream, this);
                if (this.context.debugLevel > 0) {
                    tracepoint.debugInfo = this.debugOffsets.size() > 0 ? (TracePointDebugInfo)this.debugOffsets.remove(0) : new TracePointDebugInfo(-1, -1);
                }
            }
            if (tracepoint == null) {
                return null;
            }
        }
        catch (BufferUnderflowException e) {
            TraceRecord record = null;
            if (this.records.isEmpty()) {
                return null;
            }
            record = (TraceRecord)this.records.firstElement();
            this.records.remove(record);
            record.appendToStream(this.stream, this.threadRecordCount == 0L);
            ++this.threadRecordCount;
            if (this.context.debugLevel > 0) {
                Collections.reverse(record.debugOffsets);
                for (Integer offset : record.debugOffsets) {
                    this.debugOffsets.add(new TracePointDebugInfo((int)this.context.totalRecords - 1, offset));
                }
            }
            this.newestWrapTime = record.wrapTime;
            return this.getNextRegularTracepoint();
        }
        if (tracepoint.isInvalid()) {
            this.context.warning(this, "suppressing invalid tracepoint for thread " + this.threadIdentifier);
        } else if (tracepoint.isNormalTracepoint()) {
            tracepoint.time_merged = this.timerUpperWord.or(BigInteger.valueOf(tracepoint.time_lowerWord));
            return tracepoint;
        }
        long lostCount = tracepoint.getLostRecordCount();
        if (lostCount != 0L) {
            long bytes = 0L;
            if (lostCount > 0L) {
                this.threadLostRecordCount += lostCount;
                bytes = lostCount * (long)this.context.getRecordSize();
                this.context.debug(this, 2, "Tracepoint says we lost " + lostCount + " records (total for thread: " + this.threadLostRecordCount + ")");
            } else if (lostCount == -1L) {
                this.context.debug(this, 2, "Tracepoint probably injected for user discarded data of unknown size");
            } else if (lostCount < 0L) {
                this.context.error(this, "lost bytes count is negative - lost " + lostCount + " records of " + this.context.getRecordSize() + " bytes each");
                bytes = Long.MAX_VALUE;
            }
            throw new MissingDataException(this, bytes);
        }
        upperWord = tracepoint.getNewTimerUpperWord();
        if (upperWord != 0L) {
            BigInteger oldUpper = this.timerUpperWord;
            this.timerUpperWord = BigInteger.valueOf(upperWord).shiftLeft(32);
        }
        return this.getNextRegularTracepoint();
    }

    protected synchronized void addRecord(TraceRecord record) throws IllegalArgumentException {
        boolean i = true;
        if (this.userDiscardedData) {
            record.userDiscardedData = true;
            this.userDiscardedData = false;
        }
        this.records.add(record);
    }

    synchronized void userDiscardedData() {
        this.userDiscardedData = true;
    }

    public int compareTo(Object obj) {
        TraceThread thread = (TraceThread)obj;
        if (this.next != null && thread.next != null) {
            return this.next.time_merged.compareTo(thread.next.time_merged);
        }
        if (this.next == null && thread.next == null) {
            return 0;
        }
        if (this.next == null) {
            return 1;
        }
        return -1;
    }

    void refresh() {
        if (this.next == null) {
            this.context.sorted = false;
            long bytes = 0L;
            MissingDataException e = null;
            while (true) {
                try {
                    this.next = this.getNextRegularTracepoint();
                }
                catch (MissingDataException e2) {
                    bytes += e2.getMissingBytes();
                    e = e2;
                    continue;
                }
                break;
            }
            if (e != null) {
                e.missingByteCount = bytes;
                ((ThreadIterator)this.getIterator()).lostBytes = e;
            }
        }
    }

    public boolean equals(Long id) {
        return this.threadIdentifier.equals(id);
    }

    public String toString() {
        return ("[" + Long.toHexString(this.threadIdentifier) + "] " + this.threadName).intern();
    }

    public long getThreadID() {
        return this.threadID;
    }

    public long getNativeThreadID() {
        return this.nativeThreadID;
    }

    public String getThreadName() {
        return this.threadName;
    }

    class ThreadIterator
    implements Iterator {
        MissingDataException lostBytes;
        TraceThread thread;

        private ThreadIterator(TraceThread thread) {
            this.thread = thread;
        }

        public boolean hasNext() {
            TraceThread.this.refresh();
            return TraceThread.this.next != null;
        }

        public Object next() throws MissingDataException {
            MissingDataException saved = this.lostBytes;
            if (this.lostBytes != null) {
                this.lostBytes = null;
                throw saved;
            }
            TraceThread.this.live = TraceThread.this.next;
            TraceThread.this.next = null;
            TraceThread.this.refresh();
            if (TraceThread.this.live != null && TraceThread.this.live.tracepointID == 262 && TraceThread.this.live.componentName.equals("dg")) {
                TraceThread.this.context.debug(this, 2, "End of data for thread " + TraceThread.this.threadIdentifier);
                if (TraceThread.this.next == null) {
                    TraceThread.this.stream = null;
                }
                TraceThread.this.context.threadTerminated(this.thread, TraceThread.this.next != null);
            }
            return TraceThread.this.live;
        }

        public void remove() {
            throw new UnsupportedOperationException("Tracepoints are removed as they are returned by the call to next()");
        }
    }
}

