/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.jgss.mech.krb5.ServiceCreds;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KDCOptions;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.KrbTgsReq;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.CredentialsUtil;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.LoginOptions;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.krb5.internal.TicketFlags;
import com.ibm.security.krb5.internal.ccache.c;
import com.ibm.security.krb5.internal.ccache.d;
import com.ibm.security.krb5.internal.crypto.o;
import com.ibm.security.krb5.internal.ktab.KeyTab;
import com.ibm.security.krb5.internal.ktab.f;
import com.ibm.security.krb5.internal.l;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Date;

public class Credentials {
    Ticket a;
    PrincipalName b;
    PrincipalName c;
    EncryptionKey d;
    TicketFlags e;
    KerberosTime f;
    KerberosTime g;
    KerberosTime h;
    KerberosTime i;
    HostAddresses j;
    EncryptionKey[] k;
    private ServiceCreds l;
    private static d m;
    private static boolean n;
    private static boolean o;
    static Krb5Debug p;
    private Credentials q = null;
    private static final String[] z;

    public Credentials getProxy() {
        return this.q;
    }

    public Credentials setProxy(Credentials credentials) {
        this.q = credentials;
        return this;
    }

    private static native Credentials acquireDefaultNativeCreds(int[] var0);

    public Credentials(Ticket ticket, PrincipalName principalName, PrincipalName principalName2, EncryptionKey encryptionKey, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses) {
        this.a = ticket;
        this.b = principalName;
        this.c = principalName2;
        this.d = encryptionKey;
        this.e = ticketFlags;
        this.f = kerberosTime;
        this.g = kerberosTime2;
        this.h = kerberosTime3;
        this.i = kerberosTime4;
        this.j = hostAddresses;
    }

    public Credentials(byte[] byArray, String string, String string2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws KrbException, IOException {
        this(new Ticket(byArray), new PrincipalName(string), new PrincipalName(string2), new EncryptionKey(n2, byArray2), blArray == null ? null : new TicketFlags(blArray), date == null ? null : new KerberosTime(date), date2 == null ? null : new KerberosTime(date2), date3 == null ? null : new KerberosTime(date3), date4 == null ? null : new KerberosTime(date4), null);
    }

    public Credentials(PrincipalName principalName, EncryptionKey encryptionKey) throws RealmException {
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(z[40]);
        }
        if (encryptionKey == null) {
            I18NException.throwIllegalArgumentException(z[41]);
        }
        this.b = principalName;
        this.k = new EncryptionKey[1];
        this.k[0] = (EncryptionKey)encryptionKey.clone();
        if (Krb5Debug.on(3)) {
            p.out(3, z[39] + EncryptedData.encTypeToString(this.k[0].getEType()));
        }
    }

    public Credentials(String string, ServiceCreds serviceCreds) throws RealmException {
        if (serviceCreds == null) {
            I18NException.throwIllegalArgumentException(z[4]);
        }
        if (string != null) {
            this.b = new PrincipalName(string);
        }
        this.l = serviceCreds;
    }

    public Credentials(PrincipalName principalName, EncryptionKey[] encryptionKeyArray) throws RealmException {
        int n2;
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(z[5]);
        }
        if (encryptionKeyArray == null) {
            I18NException.throwIllegalArgumentException(z[10]);
        }
        this.b = principalName;
        this.k = new EncryptionKey[encryptionKeyArray.length];
        for (n2 = 0; n2 < encryptionKeyArray.length; ++n2) {
            this.k[n2] = (EncryptionKey)encryptionKeyArray[n2].clone();
        }
        if (Krb5Debug.on(3)) {
            p.out(3, z[6] + encryptionKeyArray.length + z[7]);
            for (n2 = 0; n2 < encryptionKeyArray.length; ++n2) {
                p.out(3, z[9] + (n2 + 1) + z[8] + EncryptedData.encTypeToString(this.k[n2].getEType()));
            }
        }
    }

    public final PrincipalName getClient() {
        return this.b;
    }

    public final PrincipalName getServer() {
        return this.c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EncryptionKey getSessionKey() {
        if (this.d == null) {
            if (Krb5Debug.on(3)) {
                p.out(3, z[13]);
            }
            if (this.k != null) {
                return (EncryptionKey)this.k[0].clone();
            }
            if (Krb5Debug.on(3)) {
                p.out(3, z[15]);
            }
            return null;
        }
        if (Krb5Debug.on(3) && Credentials.a(this.d.getBytes())) {
            p.out(3, z[14] + (this.d != null ? new HexDumpEncoder().encode(this.d.getBytes()) : ""));
        }
        return this.d;
    }

    public final Date getStartTime() {
        if (this.g != null) {
            return this.g.toDate();
        }
        return null;
    }

    public final Date getEndTime() {
        if (this.h != null) {
            return this.h.toDate();
        }
        return null;
    }

    public final Date getRenewTill() {
        if (this.i != null) {
            return this.i.toDate();
        }
        return null;
    }

    public final boolean[] getFlags() {
        if (this.e == null) {
            return null;
        }
        return this.e.a();
    }

    public final InetAddress[] getClientAddresses() {
        if (this.j == null) {
            return null;
        }
        return this.j.getInetAddresses();
    }

    public final byte[] getEncoded() {
        byte[] byArray = null;
        try {
            byArray = this.a.asn1Encode();
        }
        catch (Asn1Exception asn1Exception) {
            if (Krb5Debug.on(6)) {
                p.out(3, asn1Exception);
            }
        }
        catch (IOException iOException) {
            if (Krb5Debug.on(6)) {
                p.out(3, iOException);
            }
        }
        return byArray;
    }

    public boolean isRenewable() {
        return this.e.get(8);
    }

    public boolean isForwardable() {
        return this.e.get(1);
    }

    public Ticket getTicket() {
        if (Krb5Debug.on(3)) {
            p.out(3, z[0]);
        }
        return this.a;
    }

    public TicketFlags getTicketFlags() {
        return this.e;
    }

    public boolean checkDelegate() {
        boolean bl = false;
        try {
            bl = this.e.get(13);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void resetDelegate() {
        this.e.set(13, false);
    }

    public Credentials renew() throws KrbException, IOException {
        KDCOptions kDCOptions = new KDCOptions();
        boolean[] blArray = this.e.a();
        for (int i2 = 1; i2 < 6; ++i2) {
            kDCOptions.set(i2, blArray[i2]);
        }
        kDCOptions.set(30, true);
        kDCOptions.set(8, true);
        return new KrbTgsReq(kDCOptions, this, this.c, null, null, null, null, this.j, null, null, null).sendAndGetCreds();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, String string) throws KrbException, IOException {
        d d2 = com.ibm.security.krb5.internal.ccache.d.a(principalName, string);
        if (d2 == null) {
            return null;
        }
        Credentials credentials = d2.g();
        return credentials;
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, InputStream inputStream) throws KrbException, IOException {
        d d2 = com.ibm.security.krb5.internal.ccache.d.a(principalName, inputStream);
        if (d2 == null) {
            return null;
        }
        Credentials credentials = d2.g();
        return credentials;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Credentials acquireDefaultCreds() {
        Credentials credentials = null;
        m = com.ibm.security.krb5.internal.ccache.d.a();
        if (m == null) {
            return Credentials.getDefaultNativeCreds();
        }
        if (!Krb5Debug.on(3)) return m.g();
        p.out(3, z[16]);
        return m.g();
    }

    public static Credentials getServiceCreds(String string, File file) throws IOException, IllegalArgumentException {
        block23: {
            EncryptionKey[] encryptionKeyArray;
            KeyTab keyTab;
            PrincipalName principalName;
            block24: {
                principalName = null;
                PrincipalName principalName2 = null;
                if (string != null) {
                    try {
                        principalName = new PrincipalName(string);
                    }
                    catch (Exception exception) {
                        if (Krb5Debug.on(6)) {
                            p.out(3, z[31] + string + z[34] + exception.toString());
                        }
                        return null;
                    }
                }
                keyTab = null;
                keyTab = file == null ? KeyTab.getInstance() : KeyTab.getInstance(file);
                if (keyTab == null) break block23;
                if (principalName != null) break block24;
                encryptionKeyArray = keyTab.getEntry(principalName);
                if (encryptionKeyArray == null) {
                    return null;
                }
                principalName2 = encryptionKeyArray.getService();
                if (principalName2 == null) {
                    return null;
                }
                principalName = principalName2;
            }
            try {
                block25: {
                    encryptionKeyArray = keyTab.getAllKeys(principalName);
                    if (encryptionKeyArray != null && encryptionKeyArray.length > 0) break block25;
                    I18NException.throwIllegalArgumentException(z[33], new String[]{principalName.toString(), keyTab.tabName()});
                }
                return new Credentials(principalName, encryptionKeyArray);
            }
            catch (Exception exception) {
                if (Krb5Debug.on(6)) {
                    p.out(3, z[32] + exception.toString());
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Credentials getServiceCreds(PrincipalName principalName, InputStream inputStream) throws IOException, KrbException {
        EncryptionKey[] encryptionKeyArray;
        f f2 = new f(inputStream);
        if (principalName == null) {
            encryptionKeyArray = f2.a(principalName);
            if (encryptionKeyArray == null) {
                return null;
            }
            principalName = encryptionKeyArray.getService();
            if (principalName == null) {
                return null;
            }
        }
        if ((encryptionKeyArray = f2.b(principalName)) == null || encryptionKeyArray.length <= 0) {
            I18NException.throwIllegalArgumentException(z[42], new String[]{principalName.toString(), inputStream.toString()});
        }
        return new Credentials(principalName, encryptionKeyArray);
    }

    public static Credentials acquireCreds(String string) {
        Credentials credentials = null;
        try {
            PrincipalName principalName = new PrincipalName(string);
            credentials = Credentials.a(principalName, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return credentials;
    }

    public static Credentials acquireCreds(String string, String string2) {
        return Credentials.acquireCreds(string);
    }

    private static Credentials a(PrincipalName principalName, String string, LoginOptions loginOptions) {
        Credentials credentials;
        block25: {
            PrincipalName principalName2 = null;
            credentials = null;
            String string2 = principalName.getRealmString();
            try {
                c c2;
                block29: {
                    block27: {
                        block28: {
                            block26: {
                                if (principalName == null || string2 == null) break block25;
                                principalName2 = PrincipalName.tgsService(string2, string2);
                                m = string == null ? com.ibm.security.krb5.internal.ccache.d.a(principalName) : com.ibm.security.krb5.internal.ccache.d.a(principalName, string);
                                if (m == null || m.c().match(principalName)) break block26;
                                m = null;
                            }
                            if (m != null) break block27;
                            if (string != null) break block28;
                            m = com.ibm.security.krb5.internal.ccache.d.a(principalName);
                            break block27;
                        }
                        m = com.ibm.security.krb5.internal.ccache.d.a(principalName, string);
                    }
                    if (m == null || m.e() == null) break block25;
                    c2 = m.a(loginOptions, principalName2);
                    if (c2 == null || !c2.a()) break block25;
                    if (!Krb5Debug.on(3)) break block29;
                    p.out(3, z[53]);
                }
                credentials = c2.f();
            }
            catch (Exception exception) {
                credentials = null;
            }
        }
        if (credentials == null) {
            m = null;
        }
        return credentials;
    }

    public static Credentials acquireServiceCreds(PrincipalName principalName, Credentials credentials) throws Exception {
        return Credentials.acquireServiceCreds(principalName, credentials, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Credentials acquireServiceCreds(PrincipalName principalName, Credentials credentials, KDCOptions kDCOptions, HostAddresses hostAddresses) throws KrbException, Exception {
        Credentials credentials2 = com.ibm.security.krb5.internal.l.a(principalName, credentials, kDCOptions, hostAddresses);
        if (credentials2 == null) return credentials2;
        if (!Krb5Debug.on(3)) return credentials2;
        p.out(3, z[54]);
        Credentials.printDebug(credentials2);
        return credentials2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Credentials acquireSvcCreds(PrincipalName principalName, KDCOptions kDCOptions, HostAddresses hostAddresses) throws KrbException, Exception {
        l l2 = new l();
        Credentials credentials = l2.d(principalName, this, kDCOptions, hostAddresses);
        if (credentials == null) return credentials;
        if (!Krb5Debug.on(3)) return credentials;
        p.out(3, z[3]);
        Credentials.printDebug(credentials);
        return credentials;
    }

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.acquireServiceCreds(string, credentials);
    }

    public static Credentials acquireS4U2selfCreds(PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.acquireS4U2selfCreds(principalName, credentials);
    }

    public static Credentials acquireS4U2proxyCreds(String string, Ticket ticket, PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.acquireS4U2proxyCreds(string, ticket, principalName, credentials);
    }

    public d getCache() {
        return m;
    }

    public EncryptionKey getServiceKey() {
        if (this.k != null) {
            return (EncryptionKey)this.k[0].clone();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EncryptionKey getServiceKey(int n2) {
        EncryptionKey[] encryptionKeyArray = this.getServiceKeys();
        int n3 = 0;
        while (n3 < encryptionKeyArray.length) {
            if (encryptionKeyArray[n3].getEType() == n2) {
                return encryptionKeyArray[n3];
            }
            ++n3;
        }
        return null;
    }

    public EncryptionKey[] getServiceCredKeys(PrincipalName principalName) {
        return this.l.getEKeys(principalName);
    }

    public EncryptionKey[] getServiceKeys() {
        if (this.k == null) {
            return null;
        }
        EncryptionKey[] encryptionKeyArray = new EncryptionKey[this.k.length];
        for (int i2 = 0; i2 < this.k.length; ++i2) {
            encryptionKeyArray[i2] = (EncryptionKey)this.k[i2].clone();
        }
        return encryptionKeyArray;
    }

    public void setServiceKey(EncryptionKey encryptionKey) throws Exception {
        if (encryptionKey == null) {
            I18NException.throwException(z[11]);
        }
        if (this.k != null) {
            I18NException.throwException(z[12]);
        }
        this.k = new EncryptionKey[1];
        this.k[0] = (EncryptionKey)encryptionKey.clone();
    }

    public void setServiceKeys(EncryptionKey[] encryptionKeyArray) throws Exception {
        if (encryptionKeyArray == null) {
            I18NException.throwException(z[1]);
        }
        if (this.k != null) {
            I18NException.throwException(z[2]);
        }
        this.k = new EncryptionKey[encryptionKeyArray.length];
        for (int i2 = 0; i2 < this.k.length; ++i2) {
            this.k[i2] = (EncryptionKey)encryptionKeyArray[i2].clone();
        }
    }

    public static void printDebug(Credentials credentials) {
        block7: {
            block6: {
                System.out.println(z[23]);
                PrintStream printStream = System.out;
                StringBuilder stringBuilder = new StringBuilder().append(z[21]);
                String string = credentials.b != null ? credentials.b.toString() : "";
                printStream.println(stringBuilder.append(string).toString());
                PrintStream printStream2 = System.out;
                StringBuilder stringBuilder2 = new StringBuilder().append(z[17]);
                String string2 = credentials.c != null ? credentials.c.toString() : "";
                printStream2.println(stringBuilder2.append(string2).toString());
                System.out.println(z[18] + credentials.a.sname.toString());
                if (credentials.g == null) break block6;
                System.out.println(z[22] + credentials.g.getTime());
                break block7;
            }
            System.out.println(z[19]);
        }
        System.out.println(z[20] + credentials.h.getTime());
        System.out.println(z[24]);
    }

    public static synchronized void ensureLoaded() {
        block9: {
            block8: {
                if (!n && !o) break block8;
                return;
            }
            o = true;
            try {
                AccessController.doPrivileged(new com.ibm.security.krb5.c());
                n = true;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (Krb5Debug.on(6)) {
                    exception.printStackTrace();
                    Krb5Debug krb5Debug = new Krb5Debug(z[35]);
                    krb5Debug.out(3, z[38] + exception);
                }
            }
            catch (Exception exception) {
                if (!Krb5Debug.on(6)) break block9;
                exception.printStackTrace();
                Krb5Debug krb5Debug = new Krb5Debug(z[36]);
                krb5Debug.out(3, z[37] + exception);
            }
        }
    }

    public static Credentials getDefaultNativeCreds() {
        Credentials credentials = null;
        String string = Credentials.a(z[29]);
        if (!string.startsWith(z[28])) {
            return null;
        }
        if (!o) {
            try {
                Credentials.ensureLoaded();
            }
            catch (Exception exception) {
                if (Krb5Debug.on(3)) {
                    p.out(3, z[27]);
                    exception.printStackTrace();
                }
                o = true;
            }
        }
        if (n) {
            p.out(3, z[26]);
            credentials = Credentials.acquireDefaultNativeCreds(com.ibm.security.krb5.internal.crypto.o.a(z[30]));
        } else {
            p.out(3, z[25]);
        }
        return credentials;
    }

    public Date getAuthTime() {
        if (this.f == null) {
            return null;
        }
        return this.f.toDate();
    }

    public static boolean isAlreadyLoaded() {
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[48]);
        stringBuffer.append(z[49]).append(this.b);
        stringBuffer.append(z[52]).append(this.c);
        if (this.f != null) {
            stringBuffer.append(z[43]).append(this.f);
        }
        if (this.g != null) {
            stringBuffer.append(z[50]).append(this.g);
        }
        stringBuffer.append(z[47]).append(this.h);
        stringBuffer.append(z[44]).append(this.i);
        stringBuffer.append(z[51]).append(this.e);
        stringBuffer.append(z[45]).append(this.d.getEType());
        stringBuffer.append(z[46]).append(this.a.encPart.a);
        return stringBuffer.toString();
    }

    public ServiceCreds getServiceCreds() {
        return this.l;
    }

    private static String a(String string) {
        String string2 = AccessController.doPrivileged(new com.ibm.security.krb5.d(string));
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean a(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[57];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "Et\\.\u0019yxF<KCxK0\u000ec";
        int n3 = -1;
        block64: while (true) {
            char[] cArray;
            block69: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block68: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block68;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block69;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 23;
                                break;
                            }
                            case 1: {
                                n9 = 17;
                                break;
                            }
                            case 2: {
                                n9 = 40;
                                break;
                            }
                            case 3: {
                                n9 = 91;
                                break;
                            }
                            default: {
                                n9 = 107;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "YdD7 rh";
                    n3 = 0;
                    continue block64;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "RiA(\u001f~\u007fO\u0010\u000enb";
                    n3 = 1;
                    continue block64;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ")/\u0016\u0018\u0019ruM5\u001f~pD(EvrY.\u0002et{-\bTcM?\u0018-1Z>\u001fbcF2\u0005p1K)\u000esb\u0012";
                    n3 = 2;
                    continue block64;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "YdD7 rh";
                    n3 = 3;
                    continue block64;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "YdD7%v|M";
                    n3 = 4;
                    continue block64;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = ")/\u0016{(etL>\u0005cxI7\u0018-1k)\u000eveM?KTcM?\u000eyeA:\u0007d1_2\u001f\u007f1";
                    n3 = 5;
                    continue block64;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "7zM\"\u001891c>\u00127eQ+\u000ed+";
                    n3 = 6;
                    continue block64;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "J1";
                    n3 = 7;
                    continue block64;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u001eJ";
                    n3 = 8;
                    continue block64;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "YdD7 rh";
                    n3 = 9;
                    continue block64;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "YdD7 rh";
                    n3 = 10;
                    continue block64;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "RiA(\u001f~\u007fO\u0010\u000enb";
                    n3 = 11;
                    continue block64;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "Dt[(\u0002x\u007f\b\u0010\u000en1A(KQxZ(\u001f7BM)\u001d~rM{ rh";
                    n3 = 12;
                    continue block64;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "Dt[(\u0002x\u007f\b\u0010\u000en1A(KX\u007fD\"KDtZ-\u0002tt\b\u0010\u000en+\b";
                    n3 = 13;
                    continue block64;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "V}D{ rh[{\net\b\u0015\u001e{}";
                    n3 = 14;
                    continue block64;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = ")/\u0016\u0010\u0019uRZ>\u000fd1N4\u001eyu\b/\u0003r1L>\rvdD/KcxK0\u000ec1O)\nyeA5\f7eA8\u0000re\b2\u00057rZ>\u000fr\u007f\\2\n{1K:\b\u007ft\u0006";
                    n3 = 15;
                    continue block64;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\u001ebM)\u001drc\u0012{";
                    n3 = 16;
                    continue block64;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u001eeA8\u0000re\u0012{\u0018ypE>Q7";
                    n3 = 17;
                    continue block64;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u001eb\\:\u0019cEA6\u000e-1f\u000e'[";
                    n3 = 18;
                    continue block64;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "\u001etF??~|MaK";
                    n3 = 19;
                    continue block64;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "\u001erD2\u000eye\u0012{";
                    n3 = 20;
                    continue block64;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "\u001eb\\:\u0019cEA6\u000e-1";
                    n3 = 21;
                    continue block64;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = ")/\u0016\u001f.UDoaK:<\u0005v(etL>\u0005cxI7\u0018:<\u0005v";
                    n3 = 22;
                    continue block64;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "71\b{K71\bvF:<k)\u000estF/\u0002v}[{\u000eyu\u0005vF:";
                    n3 = 23;
                    continue block64;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = ")/\u0016\u0018\u0019ruM5\u001f~pD(Q7\u007fG{\u0005veA-\u000e7RZ>\u000fr\u007f\\2\n{b\b7\u0004vuM?";
                    n3 = 24;
                    continue block64;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = ")/\b\u001a\bfdA)\u000e7uM=\nb}\\{\u0005veA-\u000e7RZ>\u000fr\u007f\\2\n{b";
                    n3 = 25;
                    continue block64;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "TpF{\u0005xe\b7\u0004vu\b8\u0019ruM5\u001f~pD(KtpK3\u000e";
                    n3 = 26;
                    continue block64;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "@xF?\u0004`b";
                    n3 = 27;
                    continue block64;
                }
                case 27: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 29;
                    string2 = "xb\u00065\nzt";
                    n3 = 28;
                    continue block64;
                }
                case 28: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 30;
                    string2 = "stN:\u001e{ew/\u0000cNM5\bchX>\u0018";
                    n3 = 29;
                    continue block64;
                }
                case 29: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 31;
                    string2 = ")/\u0016{(etL>\u0005cxI7\u00189vM/8rc^2\brRZ>\u000fd1M#\bra\\2\u0004y1K)\u000eveA5\f7bM)\u001d~rM{\u0005v|M{\rxc\b";
                    n3 = 30;
                    continue block64;
                }
                case 30: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 32;
                    string2 = ")/\u0016{(etL>\u0005cxI7\u00189vM/8rc^2\brRZ>\u000fd1M#\bra\\2\u0004y+\b";
                    n3 = 31;
                    continue block64;
                }
                case 31: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 33;
                    string2 = "Y~c>\u0012QcG6 cpJ\u000b\u0019~\u007fK";
                    n3 = 32;
                    continue block64;
                }
                case 32: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 34;
                    string2 = "-1";
                    n3 = 33;
                    continue block64;
                }
                case 33: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 35;
                    string2 = "TcM?\u000eyeA:\u0007d+\u0012{";
                    n3 = 34;
                    continue block64;
                }
                case 34: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 36;
                    string2 = "TcM?\u000eyeA:\u0007d+\u0012{";
                    n3 = 35;
                    continue block64;
                }
                case 35: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 37;
                    string2 = "RiK>\u001bcxG5K{~I?\u0002yv\b5\ncx^>Kt~L>Q7";
                    n3 = 36;
                    continue block64;
                }
                case 36: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 38;
                    string2 = "RiK>\u001bcxG5K{~I?\u0002yv\b5\ncx^>Kt~L>Q7";
                    n3 = 37;
                    continue block64;
                }
                case 37: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 39;
                    string2 = ")/\u0016{(etL>\u0005cxI7\u0018-1k)\u000eveM?KTcM?\u000eyeA:\u0007d1_2\u001f\u007f1\u0019{\u0000rh\b4\r7eQ+\u000e7";
                    n3 = 38;
                    continue block64;
                }
                case 38: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 40;
                    string2 = "YdD7%v|M";
                    n3 = 39;
                    continue block64;
                }
                case 39: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 41;
                    string2 = "YdD7 rh";
                    n3 = 40;
                    continue block64;
                }
                case 40: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 42;
                    string2 = "Y~c>\u0012QcG6 cpJ\u000b\u0019~\u007fK";
                    n3 = 41;
                    continue block64;
                }
                case 41: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 43;
                    string2 = "\u001dp]/\u0003CxE>V";
                    n3 = 42;
                    continue block64;
                }
                case 42: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 44;
                    string2 = "\u001dcM5\u000e`EA7\u0007*";
                    n3 = 43;
                    continue block64;
                }
                case 43: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 45;
                    string2 = "\u001dT|\"\u001br1\u0000(\u0000rh\u0001f";
                    n3 = 44;
                    continue block64;
                }
                case 44: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 46;
                    string2 = "\u001d1\b{Ccz\\{\u0000rh\u0001f";
                    n3 = 45;
                    continue block64;
                }
                case 45: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 47;
                    string2 = "\u001dtF??~|Mf";
                    n3 = 46;
                    continue block64;
                }
                case 46: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 48;
                    string2 = "TcM?\u000eyeA:\u0007d+";
                    n3 = 47;
                    continue block64;
                }
                case 47: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 49;
                    string2 = "\u001drD2\u000eye\u0015";
                    n3 = 48;
                    continue block64;
                }
                case 48: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 50;
                    string2 = "\u001db\\:\u0019cEA6\u000e*";
                    n3 = 49;
                    continue block64;
                }
                case 49: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 51;
                    string2 = "\u001dwD:\fd+\b";
                    n3 = 50;
                    continue block64;
                }
                case 50: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 52;
                    string2 = "\u001dbM)\u001drc\u0015";
                    n3 = 51;
                    continue block64;
                }
                case 51: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 53;
                    string2 = ")/\u0016\u0010\u0019uRZ>\u000fd1N4\u001eyu\b/\u0003r1^:\u0007~u\b/\u0002tzM/KpcI5\u001f~\u007fO{\u001f~rC>\u001f7xF{\betL>\u0005cxI7KtpK3\u000e9";
                    n3 = 52;
                    continue block64;
                }
                case 52: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 54;
                    string2 = ")/\u0016\u0018\u0019ruM5\u001f~pD(EvrY.\u0002et{>\u0019axK>(etL(Q7cM/\u001ee\u007fA5\f7rZ>\u000fd+";
                    n3 = 53;
                    continue block64;
                }
                case 53: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 55;
                    string2 = "-1";
                    n3 = 54;
                    continue block64;
                }
                case 54: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 56;
                    string2 = "TcM?\u000eyeA:\u0007d+";
                    n3 = 55;
                    continue block64;
                }
                case 55: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        n = false;
        o = false;
        p = new Krb5Debug(z[56] + Thread.currentThread().getName() + z[55]);
    }
}

