/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Checksum;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.APOptions;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.PAData;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.util.c;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;

public class KRBError
implements Serializable {
    private static final long serialVersionUID = 2318390148465743523L;
    public int pvno;
    public int msgType;
    public KerberosTime cTime;
    public Integer cuSec;
    public KerberosTime sTime;
    public Integer suSec;
    public int errorCode;
    public PrincipalName cname;
    public PrincipalName sname;
    public String eText;
    public byte[] eData;
    public Checksum eCksum;
    private PAData[] pa;
    private HexDumpEncoder encoder = new HexDumpEncoder();
    Krb5Debug debug;
    private static final String[] z;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.a(new DerValue((byte[])objectInputStream.readObject()));
            this.a(this.eData);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeObject(this.asn1Encode());
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public KRBError(APOptions aPOptions, KerberosTime kerberosTime, Integer n2, KerberosTime kerberosTime2, Integer n3, int n4, PrincipalName principalName, PrincipalName principalName2, String string, byte[] byArray) throws IOException, Asn1Exception {
        this.debug = new Krb5Debug(z[20] + Thread.currentThread().getName() + z[21]);
        this.pvno = 5;
        this.msgType = 30;
        this.cTime = kerberosTime;
        this.cuSec = n2;
        this.sTime = kerberosTime2;
        this.suSec = n3;
        this.errorCode = n4;
        this.cname = principalName;
        this.sname = principalName2;
        this.eText = string;
        this.eData = byArray;
        this.a(this.eData);
    }

    public KRBError(APOptions aPOptions, KerberosTime kerberosTime, Integer n2, KerberosTime kerberosTime2, Integer n3, int n4, PrincipalName principalName, PrincipalName principalName2, String string, byte[] byArray, Checksum checksum) throws IOException, Asn1Exception {
        this.debug = new Krb5Debug(z[15] + Thread.currentThread().getName() + z[16]);
        this.pvno = 5;
        this.msgType = 30;
        this.cTime = kerberosTime;
        this.cuSec = n2;
        this.sTime = kerberosTime2;
        this.suSec = n3;
        this.errorCode = n4;
        this.cname = principalName;
        this.sname = principalName2;
        this.eText = string;
        this.eData = byArray;
        this.eCksum = checksum;
        this.a(this.eData);
    }

    public KRBError(byte[] byArray) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.debug = new Krb5Debug(z[0] + Thread.currentThread().getName() + z[1]);
        this.a(new DerValue(byArray));
        this.a(this.eData);
    }

    public KRBError(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.debug = new Krb5Debug(z[22] + Thread.currentThread().getName() + z[23]);
        this.a(derValue);
        this.a();
        this.a(this.eData);
    }

    private void a(byte[] byArray) throws IOException {
        block7: {
            if (byArray == null) {
                return;
            }
            if (this.errorCode != 25 && this.errorCode != 24) break block7;
            try {
                this.b(byArray);
            }
            catch (Exception exception) {
                this.debug.out(9, z[19] + this.encoder.encodeBuffer(byArray));
                IOException iOException = new IOException(z[17]);
                iOException.initCause(exception);
                throw iOException;
            }
        }
        this.debug.out(9, z[18] + this.encoder.encodeBuffer(byArray));
    }

    private void b(byte[] byArray) throws IOException, Asn1Exception {
        DerValue derValue = new DerValue(byArray);
        ArrayList<PAData> arrayList = new ArrayList<PAData>();
        while (derValue.getData().available() > 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            PAData pAData = new PAData(derValue2);
            arrayList.add(pAData);
            this.debug.out(9, z[24] + pAData);
        }
        this.pa = arrayList.toArray(new PAData[arrayList.size()]);
    }

    public final KerberosTime getServerTime() {
        return this.sTime;
    }

    public final KerberosTime getClientTime() {
        return this.cTime;
    }

    public final Integer getServerMicroSeconds() {
        return this.suSec;
    }

    public final Integer getClientMicroSeconds() {
        return this.cuSec;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorString() {
        return this.eText;
    }

    public final byte[] getEData() {
        return this.eData;
    }

    public final PAData[] getPA() {
        return this.pa;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((derValue.getTag() & 0x1F) != 30 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.pvno = derValue3.getData().getBigInteger().intValue();
        if (this.pvno != 5) {
            throw new KrbApErrException(39);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.msgType = derValue3.getData().getBigInteger().intValue();
        if (this.msgType != 30) {
            throw new KrbApErrException(40);
        }
        this.cTime = KerberosTime.parse(derValue2.getData(), (byte)2, true);
        if ((derValue2.getData().peekByte() & 0x1F) == 3) {
            derValue3 = derValue2.getData().getDerValue();
            this.cuSec = new Integer(derValue3.getData().getBigInteger().intValue());
        } else {
            this.cuSec = null;
        }
        this.sTime = KerberosTime.parse(derValue2.getData(), (byte)4, false);
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 5) {
            throw new Asn1Exception(906);
        }
        this.suSec = new Integer(derValue3.getData().getBigInteger().intValue());
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 6) {
            throw new Asn1Exception(906);
        }
        this.errorCode = derValue3.getData().getBigInteger().intValue();
        Realm realm = Realm.parse(derValue2.getData(), (byte)7, true);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)8, true, realm);
        Realm realm2 = Realm.parse(derValue2.getData(), (byte)9, false);
        this.sname = PrincipalName.parse(derValue2.getData(), (byte)10, false, realm2);
        this.eText = null;
        this.eData = null;
        this.eCksum = null;
        if (derValue2.getData().available() > 0 && (derValue2.getData().peekByte() & 0x1F) == 11) {
            derValue3 = derValue2.getData().getDerValue();
            this.eText = new c(derValue3.getData().getDerValue()).toString();
        }
        if (derValue2.getData().available() > 0 && (derValue2.getData().peekByte() & 0x1F) == 12) {
            derValue3 = derValue2.getData().getDerValue();
            this.eData = derValue3.getData().getOctetString();
        }
        if (derValue2.getData().available() > 0) {
            this.eCksum = Checksum.parse(derValue2.getData(), (byte)13, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.pvno));
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream);
        if (this.cTime != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.cTime.asn1Encode());
        }
        if (this.cuSec != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.cuSec.intValue()));
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.sTime.asn1Encode());
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.suSec.intValue()));
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.errorCode));
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), derOutputStream);
        if (this.cname != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)7), this.cname.getRealm().asn1Encode());
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)8), this.cname.asn1Encode());
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.sname.getRealm().asn1Encode());
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.sname.asn1Encode());
        if (this.eText != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putDerValue(new c(this.eText).b());
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)11), derOutputStream);
        }
        if (this.eData != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(this.eData);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)12), derOutputStream);
        }
        if (this.eCksum != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)13), this.eCksum.asn1Encode());
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, (boolean)true, (byte)30), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    private void a() {
        if (Krb5Debug.on(9)) {
            this.debug.out(9, z[14]);
            if (this.cTime != null) {
                this.debug.out(9, z[5] + this.cTime.toDate().toString() + " " + this.cTime.toDate().getTime());
            }
            if (this.cuSec != null) {
                this.debug.out(9, z[6] + this.cuSec);
            }
            this.debug.out(9, z[8] + this.sTime.toDate().toString() + " " + this.sTime.toDate().getTime());
            this.debug.out(9, z[2] + this.suSec);
            this.debug.out(9, z[3] + this.errorCode);
            KrbException krbException = new KrbException(this.errorCode);
            this.debug.out(9, z[13] + krbException.getLocalizedMessage());
            if (this.cname != null) {
                this.debug.out(9, z[7] + this.cname.toString());
            }
            if (this.sname != null) {
                this.debug.out(9, z[10] + this.sname.toString());
            }
            if (this.eText != null) {
                this.debug.out(9, z[9] + this.eText);
            }
            if (this.eData != null) {
                this.debug.out(9, z[12]);
            }
            if (this.eCksum != null) {
                this.debug.out(9, z[11]);
            }
            this.debug.out(9, z[4] + this.msgType);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KRBError)) {
            return false;
        }
        KRBError kRBError = (KRBError)object;
        return this.pvno == kRBError.pvno && this.msgType == kRBError.msgType && KRBError.a(this.cTime, kRBError.cTime) && KRBError.a(this.cuSec, kRBError.cuSec) && KRBError.a(this.sTime, kRBError.sTime) && KRBError.a(this.suSec, kRBError.suSec) && this.errorCode == kRBError.errorCode && KRBError.a(this.cname, kRBError.cname) && KRBError.a(this.sname, kRBError.sname) && KRBError.a(this.eText, kRBError.eText) && Arrays.equals(this.eData, kRBError.eData) && KRBError.a(this.eCksum, kRBError.eCksum);
    }

    private static boolean a(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + this.pvno;
        n2 = 37 * n2 + this.msgType;
        if (this.cTime != null) {
            n2 = 37 * n2 + this.cTime.hashCode();
        }
        if (this.cuSec != null) {
            n2 = 37 * n2 + this.cuSec.hashCode();
        }
        if (this.sTime != null) {
            n2 = 37 * n2 + this.sTime.hashCode();
        }
        if (this.suSec != null) {
            n2 = 37 * n2 + this.suSec.hashCode();
        }
        n2 = 37 * n2 + this.errorCode;
        if (this.cname != null) {
            n2 = 37 * n2 + this.cname.hashCode();
        }
        if (this.sname != null) {
            n2 = 37 * n2 + this.sname.hashCode();
        }
        if (this.eText != null) {
            n2 = 37 * n2 + this.eText.hashCode();
        }
        n2 = 37 * n2 + Arrays.hashCode(this.eData);
        if (this.eCksum != null) {
            n2 = 37 * n2 + this.eCksum.hashCode();
        }
        return n2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[25];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "p%@)\u0017I\u0018pV";
        int n3 = -1;
        block32: while (true) {
            char[] cArray;
            block37: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block36: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block36;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block37;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 59;
                                break;
                            }
                            case 1: {
                                n9 = 119;
                                break;
                            }
                            case 2: {
                                n9 = 2;
                                break;
                            }
                            case 3: {
                                n9 = 108;
                                break;
                            }
                            default: {
                                n9 = 101;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0001W";
                    n3 = 0;
                    continue block32;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "2Wq\u00196^\u0014\"\u0005\u0016\u001b";
                    n3 = 1;
                    continue block32;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "2Wg\u001e\u0017T\u0005\"\u000f\n_\u0012\"\u0005\u0016\u001b";
                    n3 = 2;
                    continue block32;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "2Wo\u001f\u0002o\u000er\tER\u0004\"";
                    n3 = 3;
                    continue block32;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "2Wa8\fV\u0012\"\u0005\u0016\u001b";
                    n3 = 4;
                    continue block32;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "2Wa\u00196^\u0014\"\u0005\u0016\u001b";
                    n3 = 5;
                    continue block32;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "2Wa\u0002\u0004V\u0012\"\u0005\u0016\u001b";
                    n3 = 6;
                    continue block32;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "2Wq8\fV\u0012\"\u0005\u0016\u001b";
                    n3 = 7;
                    continue block32;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "2Wg\u0018\u0000C\u0003\"\u0005\u0016\u001b";
                    n3 = 8;
                    continue block32;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "2Wq\u0002\u0004V\u0012\"\u0005\u0016\u001b";
                    n3 = 9;
                    continue block32;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "2Wa\u0004\u0000X\u001cq\u0019\b\u001b\u001eqL\u0015I\u0018t\u0005\u0001^\u0013,";
                    n3 = 10;
                    continue block32;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "2Wg(\u0004O\u0016\"\u0005\u0016\u001b\u0007p\u0003\u0013R\u0013g\bK";
                    n3 = 11;
                    continue block32;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "2Wg\u001e\u0017T\u0005\"!\u0000H\u0004c\u000b\u0000\u001b\u001eqL";
                    n3 = 12;
                    continue block32;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u0005I<'7y2p\u001e\nIM";
                    n3 = 13;
                    continue block32;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "p%@)\u0017I\u0018pV";
                    n3 = 14;
                    continue block32;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\u0001W";
                    n3 = 15;
                    continue block32;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "n\u0019c\u000e\t^Wv\u0003EK\u0016p\u001f\u0000\u001b\u0012F\r\u0011ZWd\u0005\u0000W\u0013\"\u0003\u0003\u001b<P.H~%P#7";
                    n3 = 16;
                    continue block32;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "n\u0019i\u0002\nL\u0019\"\t!Z\u0003cL\u0003R\u0012n\bET\u0011\"'7yZG>7t%8f";
                    n3 = 17;
                    continue block32;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "n\u0019c\u000e\t^Wv\u0003EK\u0016p\u001f\u0000\u001b\u0012F\r\u0011ZWd\u0005\u0000W\u0013\"\u0003\u0003\u001b<P.H~%P#7\u0001}";
                    n3 = 18;
                    continue block32;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "p%@)\u0017I\u0018pV";
                    n3 = 19;
                    continue block32;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "\u0001W";
                    n3 = 20;
                    continue block32;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "p%@)\u0017I\u0018pV";
                    n3 = 21;
                    continue block32;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "\u0001W";
                    n3 = 22;
                    continue block32;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "K\u0016]\b\u0004O\u00168L";
                    n3 = 23;
                    continue block32;
                }
                case 23: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

