/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.internal.LastReqEntry;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.util.Vector;

public class LastReq {
    public LastReqEntry[] entry;

    public LastReq(LastReqEntry[] lastReqEntryArray) {
        this.entry = lastReqEntryArray;
    }

    public LastReq(DerValue derValue) throws Asn1Exception, IOException {
        Vector<LastReqEntry> vector = new Vector<LastReqEntry>();
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        while (derValue.getData().available() > 0) {
            vector.addElement(new LastReqEntry(derValue.getData().getDerValue()));
        }
        if (vector.size() > 0) {
            this.entry = new LastReqEntry[vector.size()];
            vector.copyInto(this.entry);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        block5: {
            DerOutputStream derOutputStream = new DerOutputStream();
            if (this.entry == null || this.entry.length <= 0) break block5;
            DerOutputStream derOutputStream2 = new DerOutputStream();
            for (int i2 = 0; i2 < this.entry.length; ++i2) {
                derOutputStream2.write(this.entry[i2].asn1Encode());
            }
            derOutputStream.write((byte)48, derOutputStream2);
            return derOutputStream.toByteArray();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LastReq parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new LastReq(derValue2);
    }
}

