/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.orb;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.orb.CallLink;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.ChannelTransportConnection;
import com.ibm.rmi.channel.orb.ORBChannelHelper;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.ORB;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.io.IOException;

public class ORBServerCallLink
extends InboundApplicationLink
implements CallLink {
    private static final String CLASS = ORBServerCallLink.class.getName();
    private GIOPConnectionContext connCtx = null;
    private ORBChannelHelper channelHelper;
    private Connection conn;
    private GIOPMessageContext msgCtx;

    @Override
    public void setGIOPConnectionContext(GIOPConnectionContext gIOPConnectionContext) {
        this.connCtx = gIOPConnectionContext;
    }

    @Override
    public GIOPConnectionContext getGIOPConnectionContext() {
        return this.connCtx;
    }

    public ORBServerCallLink(VirtualConnection virtualConnection, ORBChannelHelper oRBChannelHelper) {
        this.init(virtualConnection);
        this.channelHelper = oRBChannelHelper;
    }

    public void ready(VirtualConnection virtualConnection) {
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
    }

    public void destroy(Exception exception) {
        this.msgCtx.release();
    }

    @Override
    public void processMessage(GIOPMessageContext gIOPMessageContext) {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "processMessage:167");
        }
        this.msgCtx = gIOPMessageContext;
        ORB oRB = this.channelHelper.getOrb();
        ChannelTransportConnection channelTransportConnection = new ChannelTransportConnection(oRB, this.connCtx);
        this.conn = new Connection(oRB, oRB.getServerGIOP(), true);
        this.conn.setContext(this, channelTransportConnection, this.connCtx);
        try {
            this.channelHelper.processCall(this.conn, this.connCtx, gIOPMessageContext);
        }
        catch (Exception exception) {
            block8: {
                if (Trc.enabled()) {
                    Trc.warn(exception, CLASS, "processMessage:182");
                }
                if (gIOPMessageContext.isResponseExpected()) {
                    try {
                        this.connCtx.sendExceptionResponse(exception, gIOPMessageContext, -1);
                    }
                    catch (IOException iOException) {
                        if (!Trc.enabled()) break block8;
                        Trc.warn(iOException, CLASS, "processMessage:191");
                    }
                }
            }
            this.connCtx.finishRequest(gIOPMessageContext.getRequestId());
            this.destroy(exception);
        }
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, CLASS, "processMessage:203");
        }
    }

    @Override
    public void errorResponse(Exception exception) {
        if (Trc.enabled()) {
            Trc.warn("should never be called on Server", CLASS, "errorResponse:221");
        }
    }
}

