/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.CDRWriter;
import com.ibm.rmi.iiop.CharToTcsConverter;
import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.util.Utility;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;

public class CollocatedCDROutputStream
extends CDRWriter {
    private static final String CLASS = CollocatedCDROutputStream.class.getName();
    protected byte[] buf = new byte[512];
    protected int index = 0;
    private static final int SIZE = 512;
    private static final int CACHE_PIECE_SIZE_LIMIT = 8192;
    private static final int PIECE_SIZE = 1024;
    private int blockSizePosition = -1;
    private int endFlagPosition = -1;
    private int currentSize = 512;
    private byte[] tempData = new byte[8];
    private static String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static String[] _ids = new String[]{_id};
    private static final long serialVersionUID = 0L;

    public CollocatedCDROutputStream(ORB oRB, boolean bl, int n, EncoderOutputStream encoderOutputStream) {
        super(oRB, bl, n, encoderOutputStream);
    }

    public CollocatedCDROutputStream(EncoderOutputStream encoderOutputStream, EncoderOutputStream encoderOutputStream2) {
        super(encoderOutputStream, encoderOutputStream2);
    }

    @Override
    public void releaseBuffer() {
        this.buf = null;
        this.initialOffset = 0;
        this.index = 0;
        this.blockSizePosition = -1;
        this.endFlagPosition = -1;
        if (this.currentSize > 8192) {
            this.buf = null;
            this.currentSize = 0;
        }
    }

    @Override
    void clearStreamData() {
        this.initialOffset = 0;
        this.index = 0;
        this.blockSizePosition = -1;
        this.endFlagPosition = -1;
        if (this.currentSize > 8192) {
            this.buf = null;
            this.currentSize = 0;
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = this.buf == null ? ByteBuffer.ZERO_BYTE_ARRAY : this.buf;
        return byArray;
    }

    @Override
    public WsByteBuffer[] toByteBuffer() {
        throw new INTERNAL("WsByteBuffer[] format is not supported in CollocatedCDROutputStream");
    }

    @Override
    protected void pad(int n) {
        for (int i = 0; i < n; ++i) {
            this.buf[this.index++] = -67;
        }
    }

    @Override
    protected final void align(int n) {
        int n2;
        if (this.buf == null) {
            this.allocateBuffer();
        }
        if (n > 1 && (n2 = this.index & n - 1) != 0) {
            n2 = n - n2;
            this.pad(n2);
        }
    }

    @Override
    protected final int alignAndReserve(int n, int n2) {
        if (this.buf != null) {
            this.align(n);
        } else {
            this.allocateBuffer();
        }
        if (this.index + n2 > this.currentSize) {
            this.grow(n2);
        }
        return n2 / n;
    }

    private void grow(int n) {
        int n2 = this.currentSize + n;
        do {
            if (this.currentSize <= 1024) {
                this.currentSize *= 2;
                continue;
            }
            this.currentSize += 1024;
        } while (this.currentSize < n2);
        byte[] byArray = Arrays.copyOf(this.buf, this.currentSize);
        this.buf = byArray;
    }

    @Override
    protected final void rememberBlockSizePosition() {
        this.blockSizePosition = this.index;
    }

    @Override
    protected final void forgetBlockSizePosition() {
        this.blockSizePosition = -1;
    }

    @Override
    protected final void writeBlockSizeHere(int n) {
        this.blockSizePosition = this.write_long(n, false, true);
    }

    @Override
    protected final void rewriteBlockSize(int n, int n2) {
        int n3 = this.blockSizePosition + 4;
        int n4 = n + this.index + n2;
        int n5 = n4 - n3;
        this.rewriteLong(n5, this.blockSizePosition);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "block length: ", Trc.hex(n5), CLASS, "rewriteBlockSize:240");
        }
    }

    @Override
    protected final void clearEndFlagMarker() {
        this.endFlagPosition = -1;
    }

    @Override
    public InputStream create_input_stream() {
        final byte[] byArray = this.toByteArray();
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new EncoderInputStream(CollocatedCDROutputStream.this.encoderStream, byArray, CollocatedCDROutputStream.this.index);
            }
        });
    }

    @Override
    public void write_octet(byte by) {
        this.write_octet(by, false);
    }

    @Override
    public final Object writePlaceHolderOctet(byte by) {
        return this.write_octet(by, true);
    }

    @Override
    public final void rewriteOctet(byte by, Object object) {
        this.buf[((Integer)object).intValue()] = by;
    }

    int write_octet(byte by, boolean bl) {
        int n = -1;
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(1, 1);
        if (bl) {
            n = this.index;
        }
        this.buf[this.index++] = by;
        return n;
    }

    @Override
    protected final void writeBoolean(boolean bl) {
        this.buf[this.index++] = CollocatedCDROutputStream.booleanToByte(bl);
    }

    @Override
    public final Object writePlaceHolderBoolean(boolean bl) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(1, 1);
        int n = this.index;
        this.writeBoolean(bl);
        return n;
    }

    @Override
    public final void rewriteBoolean(boolean bl, Object object) {
        this.buf[((Integer)object).intValue()] = CollocatedCDROutputStream.booleanToByte(bl);
    }

    private final void writeNumber(long l, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n2 == 1) {
            n5 = 0;
            n4 = n;
        } else {
            n5 = n - 1;
            n4 = -1;
        }
        while (n5 != n4) {
            this.tempData[n5] = (byte)(l & 0xFFL);
            l >>>= 8;
            n5 += n2;
        }
        if (n3 == -1) {
            System.arraycopy(this.tempData, 0, this.buf, this.index, n);
            this.index += n;
        } else {
            System.arraycopy(this.tempData, 0, this.buf, n3, n);
        }
    }

    @Override
    protected final void writeShort(int n, boolean bl) {
        this.checkPadding();
        this.writeNumber(n & 0xFFFF, 2, bl ? 1 : -1, -1);
    }

    @Override
    protected final void writeLong(int n, boolean bl) {
        this.checkPadding();
        this.writeLong(n, bl, -1);
    }

    private final void writeLong(int n, boolean bl, int n2) {
        this.writeNumber(n & 0xFFFFFFFF, 4, bl ? 1 : -1, n2);
    }

    @Override
    protected final void writeLongLong(long l, boolean bl) {
        this.checkPadding();
        this.writeNumber(l, 8, bl ? 1 : -1, -1);
    }

    public void write_wchar(char c) {
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(new char[]{c}, this.littleEndian);
        boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
        int n = cArray.length;
        int n2 = n * 2;
        int n3 = 0;
        boolean bl2 = false;
        this.checkPadding();
        this.checkChunkStart();
        if (this.isPreGiop12()) {
            if (n > 1) {
                throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - (wchar) single IDL char > 1 byte when encoded in TCS", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            n3 = this.alignAndReserve(2, n2);
        } else {
            n3 = this.alignAndReserve(1, n2 + 1);
            this.buf[this.index++] = (byte)n2;
            bl2 = --n3 == 0;
        }
        int[] nArray = CollocatedCDROutputStream.getByteShifts(2, bl);
        int n4 = 0;
        do {
            if (bl2) {
                n3 += this.alignAndReserve(1, n2 - n4);
            }
            do {
                this.buf[this.index++] = (byte)(cArray[n4 / 2] >>> nArray[n4 % 2] & 0xFF);
            } while (++n4 < n3);
            bl2 = true;
        } while (n4 < n2);
    }

    @Override
    public void write_short(short s) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(2, 2);
        this.writeShort(s, this.littleEndian);
    }

    @Override
    public void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_long(int n) {
        this.write_long(n, true);
    }

    @Override
    public final void write_long(int n, boolean bl) {
        this.write_long(n, bl, false);
    }

    @Override
    public final void rewriteLong(int n, Object object) {
        this.writeLong(n, this.littleEndian, (Integer)object);
    }

    @Override
    public final Object writePlaceHolderLong(int n) {
        return this.write_long(n, false, true);
    }

    int write_long(int n, boolean bl, boolean bl2) {
        int n2 = -1;
        this.checkPadding();
        if (bl) {
            this.checkChunkStart();
        }
        this.alignAndReserve(4, 4);
        if (bl2) {
            n2 = this.index;
        }
        this.writeLong(n, this.littleEndian, -1);
        return n2;
    }

    public void write_ulong(int n) {
        this.encoderStream.write_long(n);
    }

    @Override
    public void write_longlong(long l) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(8, 8);
        this.writeLongLong(l, this.littleEndian);
    }

    public void write_string(String string) {
        if (string == null) {
            throw new BAD_PARAM("Null Param (2) - string", 1229124098, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(string.toCharArray());
        int n = byArray.length;
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(4, 4 + n + 1);
        this.writeLong(n + 1, this.littleEndian);
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = this.alignAndReserve(1, n - i + 1);
            if (n2 + i == n + 1) {
                --n2;
            }
            System.arraycopy(byArray, i, this.buf, this.index, n2);
            this.index += n2;
        }
        this.alignAndReserve(1, 1);
        this.buf[this.index++] = 0;
    }

    public void write_wstring(String string) {
        int n;
        if (null == string) {
            throw new BAD_PARAM("Null Param (3) - wstring", 1229124099, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(string.toCharArray(), this.littleEndian);
        boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
        int n2 = cArray.length;
        if (this.isPreGiop12()) {
            this.encoderStream.write_long(n2 + 1);
        } else {
            n = n2 * 2;
            this.checkPadding();
            this.checkChunkStart();
            this.alignAndReserve(4, 4 + n);
            this.writeLong(n, this.littleEndian);
        }
        n = 0;
        int n3 = 0;
        byte[] byArray = ByteBuffer.ZERO_BYTE_ARRAY;
        for (int i = 0; i < n2; i += n) {
            int n4;
            n = this.alignAndReserve(2, (n2 - i) * 2);
            n3 = n * 2;
            if (byArray.length < n3) {
                byArray = new byte[n3];
            }
            int n5 = 0;
            for (n4 = 0; n4 < n; ++n4) {
                char c = cArray[i + n4];
                byArray[n5] = (byte)(c >>> 8 & 0xFF);
                byArray[++n5] = (byte)(c & 0xFF);
                ++n5;
            }
            if (bl) {
                for (n5 = 0; n5 < n3; n5 += 2) {
                    int n6 = n5 + 1;
                    n4 = byArray[n5];
                    byArray[n5] = byArray[n6];
                    byArray[n6] = n4;
                }
            }
            System.arraycopy(byArray, 0, this.buf, this.index, n3);
            this.index += n3;
        }
        if (this.isPreGiop12()) {
            this.write_short((short)0);
        }
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        this.write_octet_array(byArray, n, n2, true);
    }

    @Override
    public void write_octet_array(byte[] byArray, int n, int n2, boolean bl) {
        this.writeOctetArrayPiece(byArray, n, n2, true, n2);
    }

    @Override
    public final void writeOctetArrayPiece(byte[] byArray, int n, int n2, boolean bl, int n3) {
        if (byArray == null) {
            throw new BAD_PARAM("Null Param (4) - octet array", 1229124100, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            int n4;
            this.checkPadding();
            if (bl) {
                this.checkChunkStart();
            }
            for (int i = 0; i < n2; i += n4) {
                n4 = this.alignAndReserve(1, n3 - i);
                n4 = Math.min(n4, n2 - i);
                System.arraycopy(byArray, n + i, this.buf, this.index, n4);
                this.index += n4;
            }
        }
    }

    @Override
    public int get_offset(boolean bl) {
        int n = this.initialOffset;
        if (bl) {
            this.checkChunkStart();
        }
        return n += this.index;
    }

    private CharToTcsConverter getTcsCConverter() {
        if (this.tcsCConverter == null) {
            int n = this.getTcsC();
            if (n == 0) {
                n = 65537;
            }
            this.tcsCConverter = CharToTcsConverter.getConverter(n);
            if (!this.tcsCConverter.isByteOriented()) {
                throw new INTERNAL("non-byte-oriented char code set specified", 1229125042, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsCConverter;
    }

    private CharToTcsConverter getTcsWConverter() {
        if (this.tcsWConverter == null) {
            int n = this.getTcsW();
            if (n == 0) {
                throw new INV_OBJREF("wchar code set support not specified", 1330446338, CompletionStatus.COMPLETED_NO);
            }
            this.tcsWConverter = CharToTcsConverter.getConverter(n);
            if (this.tcsWConverter.isByteOriented()) {
                throw new INTERNAL("byte-oriented wchar code set specified", 1229125044, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsWConverter;
    }

    public void write_char(char c) {
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(new char[]{c});
        if (byArray.length > 1) {
            throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - (char) single IDL char > 1 byte when encoded in TCS", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        this.write_octet(byArray[0]);
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        byte[] byArray;
        if (cArray == null) {
            throw new BAD_PARAM("Null Param (8) - char array", 1229124104, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        if (n == 0 && n2 == cArray.length) {
            byArray = charToTcsConverter.convertToByte(cArray);
        } else {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            byArray = charToTcsConverter.convertToByte(cArray2);
        }
        if (byArray.length > n2) {
            throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        if (n2 > 0) {
            int n3;
            this.checkPadding();
            this.checkChunkStart();
            for (int i = 0; i < n2; i += n3) {
                n3 = this.alignAndReserve(1, n2 - i);
                System.arraycopy(byArray, i, this.buf, this.index, n3);
                this.index += n3;
            }
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM("Null Param (9) - wchar array", 1229124105, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
            boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
            if (this.isPreGiop12()) {
                Object[] objectArray;
                char[] cArray2;
                if (n == 0 && cArray.length == n2) {
                    cArray2 = charToTcsConverter.convertToChar(cArray, this.littleEndian);
                } else {
                    objectArray = new char[n2];
                    System.arraycopy(cArray, n, objectArray, 0, n2);
                    cArray2 = charToTcsConverter.convertToChar((char[])objectArray, this.littleEndian);
                }
                if (cArray2.length > n2) {
                    throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - wchar array", 1330446337, CompletionStatus.COMPLETED_NO);
                }
                objectArray = CollocatedCDROutputStream.getByteShifts(2, bl);
                int n3 = n2;
                int n4 = 0;
                int n5 = 0;
                do {
                    n5 += this.alignAndReserve(2, (n3 - n4) * 2);
                    do {
                        this.buf[this.index++] = (byte)(cArray2[n4] >>> objectArray[0] & 0xFF);
                        this.buf[this.index++] = (byte)(cArray2[n4] >>> objectArray[1] & 0xFF);
                    } while (++n4 < n5);
                } while (n4 < n3);
            } else {
                int[] nArray = CollocatedCDROutputStream.getByteShifts(2, bl);
                byte[] byArray = new byte[n2 * 3];
                int n6 = 0;
                for (int i = 0; i < n2; ++i) {
                    char[] cArray3 = charToTcsConverter.convertToChar(new char[]{cArray[n + i]}, this.littleEndian);
                    if (n6 + (cArray3.length * 2 + 1) > byArray.length) {
                        byte[] byArray2 = byArray;
                        byArray = new byte[byArray2.length * 2];
                        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                    }
                    byArray[n6++] = (byte)(cArray3.length * 2);
                    for (int j = 0; j < cArray3.length; ++j) {
                        byArray[n6++] = (byte)(cArray3[j] >>> nArray[0] & 0xFF);
                        byArray[n6++] = (byte)(cArray3[j] >>> nArray[1] & 0xFF);
                    }
                }
                this.write_octet_array(byArray, 0, n6);
            }
        }
    }

    @Override
    protected final boolean resetBufferData() {
        this.index = 0;
        return true;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.index > 0) {
            try {
                outputStream.write(this.buf, 0, this.index);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        if (this.index > 0) {
            try {
                outputStream.write(this.buf, 0, this.index);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getSize() {
        return this.index;
    }

    @Override
    protected byte[] getBuffer() {
        return this.toByteArray();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return null;
    }

    @Override
    protected byte[] convertStringToTcsBytes(String string) {
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(string.toCharArray());
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }

    @Override
    protected final void writeEndTag(int n) {
        if (this.endFlagPosition != -1 && this.endFlagPosition == this.index - 4) {
            this.rewriteLong(this.end_flag, this.endFlagPosition);
        } else {
            this.endFlagPosition = this.write_long(this.end_flag, true, true);
        }
    }

    public void writeSystemException(SystemException systemException) {
        Utility.writeSystemException(systemException, (org.omg.CORBA.portable.OutputStream)this.encoderStream);
    }

    @Override
    public void write_Abstract(Object object) {
        this.encoderStream.write_abstract_interface(object);
    }

    @Override
    public void write_Value(Serializable serializable) {
        this.encoderStream.write_value(serializable);
    }

    @Override
    public String[] _truncatable_ids() {
        return _ids;
    }

    @Override
    public final void printBuffer() {
        StringWriter stringWriter = new StringWriter(this.index * 2);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.index; i += n) {
            if (i + 16 > this.index) {
                n = Math.min(this.index - i, this.buf.length - n3);
                if (n == this.index - i) {
                    n2 = 16 - n;
                }
            } else {
                n = 16;
            }
            ByteBuffer.writeHexString(printWriter, this.buf, n3, n, n2);
            printWriter.println(new String(this.buf, n3, n));
            n3 += n;
        }
        System.out.println(stringWriter.toString());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(this.getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:962");
        throw notSerializableException;
    }

    public void setEncoderStream(EncoderOutputStream encoderOutputStream) {
        this.encoderStream = encoderOutputStream;
    }

    @Override
    protected void allocateBuffer() {
        this.buf = new byte[512];
        this.currentSize = 512;
        this.index = 0;
    }
}

