/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.ObjectSerializer;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ObjectStreamField;
import java.io.IOException;
import java.math.BigInteger;
import org.omg.CORBA.NO_IMPLEMENT;

public final class BigIntegerSerializer
extends ObjectSerializer {
    private static final BigIntegerSerializer instance = new BigIntegerSerializer();

    private BigIntegerSerializer() {
        this.vTag = (byte)80;
    }

    @Override
    public final Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        BigInteger bigInteger = (BigInteger)object;
        byte[] byArray = bigInteger.abs().toByteArray();
        int n = bigInteger.signum();
        encoderOutputStream.write_longInVarint(n);
        this.writeByteArray(encoderOutputStream, byArray);
        return null;
    }

    @Override
    public Object read(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
        iIOPInputStream.incrementDepth();
        iIOPInputStream.incrementObjectReferences();
        iIOPInputStream.filterCheck(BigInteger.class, -1);
        int n = encoderInputStream.read_longInVarint();
        BigInteger bigInteger = new BigInteger("0");
        encoderInputStream.addToValueCache(bigInteger);
        int n2 = encoderInputStream.getValueIndirection();
        byte[] byArray = (byte[])this.readByteArray(encoderInputStream);
        BigInteger bigInteger2 = new BigInteger(n, byArray);
        encoderInputStream.addToValueCache(n2, bigInteger2);
        iIOPInputStream.decrementDepth();
        return bigInteger2;
    }

    @Override
    public Object writeFields(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public Object readFields(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public Object writeReferenceFields(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass, int n) {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public Object readReferenceFields(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass, int n) {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public Object writeFn(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public Object readFn(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    public Object readFieldForMeta(EncoderInputStream encoderInputStream, Object object, ObjectStreamField objectStreamField) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    public static final BigIntegerSerializer getInstance() {
        return instance;
    }

    @Override
    public final boolean isludclPushrequired() {
        return false;
    }
}

