/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.ArraySerializer;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.util.PartnerVersionUtil;
import java.io.IOException;

public final class CharArraySerializer
extends ArraySerializer {
    private static String CLASS = CharArraySerializer.class.getName();
    private static CharArraySerializer instance = new CharArraySerializer();

    private CharArraySerializer() {
        this.vTag = (byte)92;
    }

    public static CharArraySerializer getInstance() {
        return instance;
    }

    @Override
    public Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        char[] cArray = (char[])object;
        int n = cArray.length;
        encoderOutputStream.write_longInVarint(n);
        short s = encoderOutputStream.getPartnerMajor();
        short s2 = encoderOutputStream.getPartnerMinor();
        if (PartnerVersionUtil.useOldChar(s, s2)) {
            encoderOutputStream.write_char_array(cArray, 0, n);
        } else {
            encoderOutputStream.write_wchar_array(cArray, 0, n);
        }
        return null;
    }

    @Override
    public Object read(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        int n = encoderInputStream.read_longInVarint();
        char[] cArray = new char[n];
        IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
        iIOPInputStream.incrementDepth();
        iIOPInputStream.incrementObjectReferences();
        iIOPInputStream.filterCheck(char[].class, n);
        encoderInputStream.addToValueCache(cArray);
        short s = encoderInputStream.getPartnerMajor();
        short s2 = encoderInputStream.getPartnerMinor();
        if (PartnerVersionUtil.useOldChar(s, s2)) {
            encoderInputStream.read_char_array(cArray, 0, n);
        } else {
            encoderInputStream.read_wchar_array(cArray, 0, n);
        }
        iIOPInputStream.decrementDepth();
        return cArray;
    }

    @Override
    public final boolean isludclPushrequired() {
        return false;
    }
}

