/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.ArraySerializer;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.JLBooleanArraySerializer;
import com.ibm.rmi.io.ObjectStreamClass;
import java.io.IOException;
import java.lang.reflect.Array;

public class JLIntegerArraySerializer
extends ArraySerializer {
    private static String CLASS = JLBooleanArraySerializer.class.getName();
    private static JLIntegerArraySerializer instance = new JLIntegerArraySerializer();

    private JLIntegerArraySerializer() {
        this.vTag = (byte)107;
    }

    public static JLIntegerArraySerializer getInstance() {
        return instance;
    }

    @Override
    public Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Integer[] integerArray = (Integer[])object;
        int n = integerArray.length;
        encoderOutputStream.write_longInVarint(n);
        for (Integer n2 : integerArray) {
            this.writeInteger(encoderOutputStream, n2);
        }
        return null;
    }

    @Override
    public Object read(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Integer[] integerArray = null;
        int n = encoderInputStream.read_longInVarint();
        integerArray = (Integer[])Array.newInstance(Integer.class, n);
        IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
        iIOPInputStream.incrementDepth();
        iIOPInputStream.incrementObjectReferences();
        iIOPInputStream.filterCheck(Integer[].class, n);
        encoderInputStream.addToValueCache(integerArray);
        for (int i = 0; i < n; ++i) {
            integerArray[i] = (Integer)this.readInteger(encoderInputStream);
        }
        iIOPInputStream.decrementDepth();
        return integerArray;
    }

    @Override
    public final boolean isludclPushrequired() {
        return false;
    }
}

