/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.ArraySerializer;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.ObjectStreamClass;
import java.io.IOException;
import java.lang.reflect.Array;

public class StringArraySerializer
extends ArraySerializer {
    private static String CLASS = StringArraySerializer.class.getName();
    private static StringArraySerializer instance = new StringArraySerializer();

    private StringArraySerializer() {
        this.vTag = (byte)106;
    }

    public static StringArraySerializer getInstance() {
        return instance;
    }

    @Override
    public Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        String[] stringArray = (String[])object;
        int n = stringArray.length;
        encoderOutputStream.write_longInVarint(n);
        for (String string : stringArray) {
            this.writeString(encoderOutputStream, string);
        }
        return null;
    }

    @Override
    public Object read(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        int n = 0;
        n = encoderInputStream.read_longInVarint();
        Object[] objectArray = (Object[])Array.newInstance(String.class, n);
        IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
        iIOPInputStream.incrementDepth();
        iIOPInputStream.incrementObjectReferences();
        iIOPInputStream.filterCheck(String[].class, n);
        encoderInputStream.addToValueCache(objectArray);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readString(encoderInputStream);
        }
        iIOPInputStream.decrementDepth();
        return objectArray;
    }

    @Override
    public final boolean isludclPushrequired() {
        return false;
    }
}

