/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.ras;

import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.rmi.ras.Message;
import com.ibm.rmi.ras.Trace;
import com.ibm.rmi.ras.Utility;
import java.io.PrintWriter;

public class LocateReplyMessage
extends Message {
    private static final int UNKNOWN_OBJECT = 0;
    private static final int OBJECT_HERE = 1;
    private static final int OBJECT_FORWARD = 2;
    private static final int OBJECT_FORWARD_PERM = 3;
    private static final int LOC_SYSTEM_EXCEPTION = 4;
    private static final int LOC_NEEDS_ADDRESSING_MODE = 5;

    public LocateReplyMessage(byte[] byArray) {
        super(byArray, byArray.length);
    }

    public LocateReplyMessage(byte[] byArray, int n) {
        super(byArray, n);
    }

    @Override
    public void dumpMessage(PrintWriter printWriter, TransportConnection transportConnection) {
        this.pw = printWriter;
        this.resetStream();
        printWriter.println();
        printWriter.println(Utility.getMessage("Trace.LocateReplyMessage"));
        if (transportConnection != null) {
            super.dumpMessage(printWriter, transportConnection);
        } else {
            super.dumpMessage(printWriter);
        }
        int n = this.is.read_long();
        printWriter.println(Utility.getMessage("Trace.RequestID", Integer.toString(n) + " (0x" + Integer.toHexString(n).toUpperCase() + ")"));
        if (this.GIOPMajor == 1 && (this.GIOPMinor == 0 || this.GIOPMinor == 1)) {
            this.dumpLocateStatus();
        } else {
            if (!this.dumpMessageHeader()) {
                return;
            }
            this.dumpLocateStatus12();
        }
        if (Trace.split) {
            this.dataOffset = this.is.mark();
        } else {
            printWriter.println(Utility.getMessage("Trace.DataOffset", Integer.toString(this.is.mark(), 16)));
        }
        printWriter.println();
    }

    @Override
    public void dumpMessage(PrintWriter printWriter) {
        this.dumpMessage(printWriter, (TransportConnection)null);
    }

    private void dumpLocateStatus() {
        int n = this.is.read_long();
        switch (n) {
            case 0: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "UNKNOWN_OBJECT"));
                break;
            }
            case 1: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "OBJECT_HERE"));
                break;
            }
            case 2: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "OBJECT_FORWARD"));
                break;
            }
            default: {
                this.pw.println(Utility.getMessage("Trace.UnknownReplyStatus", Integer.toString(n)));
            }
        }
    }

    private void dumpLocateStatus12() {
        int n = this.is.read_long();
        switch (n) {
            case 0: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "UNKNOWN_OBJECT"));
                break;
            }
            case 1: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "OBJECT_HERE"));
                break;
            }
            case 2: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "OBJECT_FORWARD"));
                break;
            }
            case 3: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "OBJECT_FORWARD_PERM"));
                break;
            }
            case 4: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "LOC_SYSTEM_EXCEPTION"));
                break;
            }
            case 5: {
                this.pw.println(Utility.getMessage("Trace.ReplyStatus", "LOC_NEEDS_ADDRESSING_MODE"));
                break;
            }
            default: {
                this.pw.println(Utility.getMessage("Trace.UnknownReplyStatus", Integer.toString(n)));
            }
        }
    }
}

