/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.IIOPOutputStream;
import com.ibm.rmi.util.CreateIIOPInputStream;
import com.ibm.rmi.util.CreateIIOPOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class JDKBridge {
    private static final String LOCAL_CODEBASE_KEY = "java.rmi.server.codebase";
    private static final String USE_CODEBASE_ONLY_KEY = "java.rmi.server.useCodebaseOnly";
    private static String localCodebase = null;
    private static boolean useCodebaseOnly;
    private static final boolean isJDK12 = true;

    public static boolean is12VM() {
        return true;
    }

    public static boolean isPre12VM() {
        return false;
    }

    public static String getCodebase(Class clazz) {
        return RMIClassLoader.getClassAnnotation(clazz);
    }

    public static String getLocalCodebase() {
        return localCodebase;
    }

    public static boolean useCodebaseOnly() {
        return useCodebaseOnly;
    }

    public static Remote getJRMPStub(Remote remote) throws NoSuchObjectException {
        return RemoteObject.toStub(remote);
    }

    public static void unexportJRMP(Remote remote) throws NoSuchObjectException {
        UnicastRemoteObject.unexportObject(remote, true);
    }

    public static Hashtable getPersistentFields(Class clazz) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
            for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                String string;
                String string2 = String.valueOf(objectStreamFieldArray[i].getTypeCode());
                if (objectStreamFieldArray[i].isPrimitive()) {
                    string = string2;
                } else {
                    if (objectStreamFieldArray[i].getTypeCode() == '[') {
                        string2 = "";
                    }
                    if ((string = string2 + objectStreamFieldArray[i].getType().getName().replace('.', '/')).endsWith(";")) {
                        string = string.substring(0, string.length() - 1);
                    }
                }
                hashtable.put(objectStreamFieldArray[i].getName(), string);
            }
        }
        return hashtable;
    }

    public static final void main(String[] stringArray) {
        System.out.println("1.2 VM");
    }

    public static synchronized void setCodebaseProperties() {
        String string = JDKBridge.getSystemProperty(LOCAL_CODEBASE_KEY);
        if (string != null && string.trim().length() > 0) {
            localCodebase = string;
        }
        if ((string = JDKBridge.getSystemProperty(USE_CODEBASE_ONLY_KEY)) != null && string.trim().length() > 0) {
            useCodebaseOnly = Boolean.valueOf(string);
        }
    }

    public static synchronized void setLocalCodebase(String string) {
        localCodebase = string;
    }

    public static IIOPOutputStream createOutputStream() {
        return (IIOPOutputStream)AccessController.doPrivileged(new CreateIIOPOutputStream());
    }

    public static IIOPInputStream createInputStream() {
        return (IIOPInputStream)AccessController.doPrivileged(new CreateIIOPInputStream());
    }

    private static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    static {
        JDKBridge.setCodebaseProperties();
    }
}

