/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.CorruptCoreException;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import com.ibm.dtfj.corereaders.NewElfDump;
import com.ibm.dtfj.corereaders.NewWinDump;
import com.ibm.dtfj.corereaders.NewZosDump;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DumpFactory {
    public static ICoreFileReader createDumpForCore(ImageInputStream stream) throws IOException {
        return DumpFactory.createDumpForCore(stream, false);
    }

    public static ICoreFileReader createDumpForCore(ImageInputStream stream, boolean verbose) throws IOException {
        ICoreFileReader corefile = null;
        try {
            if (NewWinDump.isSupportedDump(stream)) {
                corefile = NewWinDump.dumpFromFile(stream);
            } else if (NewElfDump.isSupportedDump(stream)) {
                corefile = NewElfDump.dumpFromFile(stream, verbose);
            } else if (NewAixDump.isSupportedDump(stream)) {
                corefile = NewAixDump.dumpFromFile(stream);
            } else if (NewZosDump.isSupportedDump(stream)) {
                corefile = NewZosDump.dumpFromFile(stream);
            }
        }
        catch (CorruptCoreException e) {
            throw new IOException("Core file was identified but found to be corrupt:  " + e.getMessage());
        }
        return corefile;
    }
}

