/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.j9.IFileLocationResolver;
import java.io.File;
import java.io.FileNotFoundException;

public class DefaultFileLocationResolver
implements IFileLocationResolver {
    private static char[] PATH_DELIMS = new char[]{'/', '\\', '.'};
    private File _supportFileDir;

    public DefaultFileLocationResolver(File parentDirectory) {
        this._supportFileDir = parentDirectory;
    }

    @Override
    public File findFileWithFullPath(String fullPath) throws FileNotFoundException {
        File[] resolvers;
        File absolute = new File(fullPath);
        String fileName = absolute.getName();
        String relativePath = this.getRelativePath(fullPath);
        for (File file : resolvers = new File[]{new File(this._supportFileDir, fileName), new File(this._supportFileDir, relativePath), absolute}) {
            if (!file.exists()) continue;
            return file;
        }
        throw new FileNotFoundException(fullPath);
    }

    private String getRelativePath(String fullPath) {
        if (fullPath.length() == 0) {
            return fullPath;
        }
        if (fullPath.length() > 3 && fullPath.charAt(1) == ':') {
            return fullPath.substring(3);
        }
        for (char delim : PATH_DELIMS) {
            if (fullPath.charAt(0) != delim) continue;
            return fullPath.substring(1);
        }
        return fullPath;
    }
}

