/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaClass;
import com.ibm.dtfj.java.javacore.JCJavaObject;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;

public class JCJavaClassLoader
implements JavaClassLoader {
    private final ImagePointer fID;
    private LinkedHashMap fClassNames;
    private JCJavaRuntime fRuntime;
    private JCJavaObject fObject;

    public JCJavaClassLoader(JCJavaRuntime javaRuntime, long id) throws JCInvalidArgumentsException {
        if (javaRuntime == null) {
            throw new JCInvalidArgumentsException("Must pass a valid runtime.");
        }
        if (!javaRuntime.getImageProcess().getImageAddressSpace().isValidAddressID(id)) {
            throw new JCInvalidArgumentsException("Must pass a valid class loader id");
        }
        this.fRuntime = javaRuntime;
        this.fID = this.fRuntime.getImageProcess().getImageAddressSpace().getPointer(id);
        this.fClassNames = new LinkedHashMap();
        this.fObject = null;
        this.fRuntime.addJavaClassLoader(this);
    }

    @Override
    public JavaClass findClass(String className) {
        JCJavaClass foundClass = null;
        if (this.fClassNames.containsKey(className)) {
            ImagePointer ip = (ImagePointer)this.fClassNames.get(className);
            if (ip != null) {
                long id = ip.getAddress();
                foundClass = this.fRuntime.findJavaClass(id);
            } else {
                foundClass = this.fRuntime.findJavaClass(className);
            }
        }
        return foundClass;
    }

    @Override
    public Iterator getCachedClasses() {
        return this.getClasses();
    }

    @Override
    public Iterator getDefinedClasses() {
        return this.getClasses();
    }

    private Iterator getClasses() {
        Vector<JavaClass> classes = new Vector<JavaClass>();
        for (Object next : this.fClassNames.keySet()) {
            classes.add(this.findClass((String)next));
        }
        return classes.iterator();
    }

    @Override
    public JavaObject getObject() throws CorruptDataException {
        return this.fObject;
    }

    public void setObject(JCJavaObject object) {
        this.fObject = object;
    }

    public JCJavaClass internalGetClass(String className) {
        return (JCJavaClass)this.findClass(className);
    }

    public JCJavaObject getInternalObject() {
        return this.fObject;
    }

    public void addClass(String name) {
        if (name != null && !this.fClassNames.containsKey(name)) {
            this.fClassNames.put(name, null);
        }
    }

    public void addClass(String name, ImagePointer ip) {
        this.fClassNames.put(name, ip);
    }

    public ImagePointer getPointerID() {
        return this.fID;
    }
}

