/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.builder.javacore;

import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageSymbol;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageModule;
import com.ibm.dtfj.image.javacore.JCImageProcess;
import com.ibm.dtfj.image.javacore.JCImageRegister;
import com.ibm.dtfj.image.javacore.JCImageStackFrame;
import com.ibm.dtfj.image.javacore.JCImageSymbol;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.builder.javacore.AbstractBuilderComponent;
import com.ibm.dtfj.javacore.builder.javacore.BuilderContainer;
import com.ibm.dtfj.javacore.builder.javacore.JavaRuntimeBuilder;
import java.util.Map;
import java.util.Properties;

public class ImageProcessBuilder
extends AbstractBuilderComponent
implements IImageProcessBuilder {
    private JCImageAddressSpace fImageAddressSpace;
    private JCImageProcess fImageProcess;
    private BuilderContainer fBuilderContainer;
    private Map registers;

    public ImageProcessBuilder(JCImageAddressSpace imageAddressSpace, String id) throws JCInvalidArgumentsException {
        super(id);
        if (imageAddressSpace == null) {
            throw new IllegalArgumentException("A valid image must be passed");
        }
        this.fImageAddressSpace = imageAddressSpace;
        this.fBuilderContainer = this.getBuilderContainer();
        this.fImageProcess = new JCImageProcess(this.fImageAddressSpace);
    }

    @Override
    public IJavaRuntimeBuilder getCurrentJavaRuntimeBuilder() {
        return (IJavaRuntimeBuilder)((Object)this.fBuilderContainer.getLastAdded());
    }

    @Override
    public IJavaRuntimeBuilder getJavaRuntimeBuilder(String builderID) {
        return (IJavaRuntimeBuilder)((Object)this.fBuilderContainer.findComponent(builderID));
    }

    @Override
    public IJavaRuntimeBuilder generateJavaRuntimeBuilder(String id) throws BuilderFailureException {
        JavaRuntimeBuilder javaRuntimeBuilder = null;
        if (this.getJavaRuntimeBuilder(id) == null) {
            try {
                javaRuntimeBuilder = new JavaRuntimeBuilder(this.fImageProcess, id);
                if (!(javaRuntimeBuilder instanceof AbstractBuilderComponent)) {
                    throw new BuilderFailureException(javaRuntimeBuilder.toString() + " must also be an " + AbstractBuilderComponent.class);
                }
                this.fBuilderContainer.add(javaRuntimeBuilder);
            }
            catch (JCInvalidArgumentsException e) {
                throw new BuilderFailureException(e);
            }
        }
        return javaRuntimeBuilder;
    }

    @Override
    public ImageModule addLibrary(String name) {
        ImageModule module = null;
        if (name != null && (module = this.fImageProcess.getLibrary(name)) == null) {
            JCImageModule jcmodule = new JCImageModule(name);
            this.fImageProcess.addLibrary(jcmodule);
            module = jcmodule;
        }
        return module;
    }

    @Override
    public void setPointerSize(int size) {
        this.fImageProcess.setPointerSize(size);
    }

    @Override
    public ImageThread addImageThread(long nativeThreadID, long systemThreadID, Properties properties) throws BuilderFailureException {
        try {
            ImagePointer pointer = this.fImageAddressSpace.getPointer(nativeThreadID);
            JCImageThread thread = this.fImageProcess.getImageThread(pointer);
            if (thread == null) {
                thread = new JCImageThread(pointer);
                if (this.registers != null) {
                    for (Map.Entry<Object, Object> entry : this.registers.entrySet()) {
                        JCImageRegister ir = new JCImageRegister((String)entry.getKey(), (Number)entry.getValue());
                        thread.addRegister(ir);
                    }
                    this.registers = null;
                }
                this.fImageProcess.addImageThread(thread);
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                thread.addProperty(entry.getKey(), entry.getValue());
            }
            if (systemThreadID != -1L) {
                pointer = this.fImageAddressSpace.getPointer(systemThreadID);
                thread.setSystemThreadID(pointer);
            }
            return thread;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    @Override
    public void setSignal(int signal) {
        this.fImageProcess.setSignal(signal);
    }

    @Override
    public void setCommandLine(String cmdLine) {
        this.fImageProcess.setCommandLine(cmdLine);
    }

    @Override
    public ImageSection addImageStackSection(ImageThread thread, ImageSection section) {
        JCImageThread thread2 = (JCImageThread)thread;
        thread2.addImageStackSection(section);
        return section;
    }

    @Override
    public void setRegisters(Map regs) {
        this.registers = regs;
    }

    @Override
    public void addEnvironmentVariable(String name, String value) {
        this.fImageProcess.addEnvironment(name, value);
    }

    @Override
    public ImageSymbol addRoutine(ImageModule library, String name, long address) {
        ImagePointer addr = this.fImageAddressSpace.getPointer(address);
        JCImageSymbol symbol = new JCImageSymbol(name, addr);
        JCImageModule mod = (JCImageModule)library;
        mod.addSymbol(symbol);
        return symbol;
    }

    @Override
    public ImageStackFrame addImageStackFrame(long nativeThreadID, String name, long baseAddress, long procAddress) {
        ImagePointer pointer = this.fImageAddressSpace.getPointer(nativeThreadID);
        JCImageThread thread = this.fImageProcess.getImageThread(pointer);
        ImagePointer ip = procAddress != -1L ? this.fImageAddressSpace.getPointer(procAddress) : null;
        JCImageStackFrame stackFrame = new JCImageStackFrame(name, null, ip);
        if (thread != null) {
            JCImageThread thrd = thread;
            thrd.addImageStackFrame(stackFrame);
        }
        return stackFrame;
    }

    @Override
    public void setExecutable(ImageModule execMod) {
        this.fImageProcess.setExecutable(execMod);
    }

    @Override
    public void setID(String pid) {
        this.fImageProcess.setID(pid);
    }

    @Override
    public void setCurrentThreadID(long imageThreadID) {
        this.fImageProcess.setCurrentThreadID(imageThreadID);
    }

    @Override
    public void addProperty(ImageModule library, String name, String value) {
        JCImageModule mod = (JCImageModule)library;
        mod.addProperty(name, value);
    }
}

