/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.framework.tag;

import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.scanner.TokenManager;
import com.ibm.dtfj.javacore.parser.framework.tag.ILineRule;
import com.ibm.dtfj.javacore.parser.j9.AttributeValueMapFactory;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import java.util.HashMap;
import java.util.regex.Matcher;

public abstract class LineRule
implements ILineRule {
    protected final StringBuffer fSource = new StringBuffer();
    protected final StringBuffer fCharSubSet = new StringBuffer();
    protected int fLineNumber = 0;
    protected int fOffset = 0;
    private HashMap fTokenList;

    @Override
    public IAttributeValueMap parseLine(String source, int lineNumber, int startingOffset) {
        this.fSource.delete(0, this.fSource.length());
        this.fSource.append(source);
        this.fLineNumber = lineNumber;
        this.fTokenList = new HashMap();
        this.processLine(source, startingOffset);
        return AttributeValueMapFactory.createAttributeValueMap(this.fTokenList);
    }

    protected int getLineNumber() {
        return this.fLineNumber;
    }

    protected abstract void processLine(String var1, int var2);

    protected IParserToken addToken(String type, Matcher matcher) {
        return this.internalAddToken(type, matcher);
    }

    protected void addToken(IParserToken token) {
        if (token != null) {
            this.fTokenList.put(token.getType(), token);
        }
    }

    protected IParserToken addToken(String type, String value) {
        IParserToken token = TokenManager.getToken(value.length(), this.fOffset, this.fLineNumber, type, value);
        this.addToken(token);
        return token;
    }

    protected IParserToken addAllCharactersAsTokenAndConsumeFirstMatch(String type, Matcher matcher) {
        matcher.reset(this.fSource);
        IParserToken token = null;
        if (matcher.find()) {
            int startIndex = matcher.start();
            int matchLength = matcher.end() - startIndex;
            token = this.addAllCharactersAsTokenUntilIndex(type, startIndex, false);
            this.fSource.delete(0, matchLength);
        }
        return token;
    }

    protected IParserToken addAllCharactersAsTokenUntilFirstMatch(String type, Matcher matcher) {
        matcher.reset(this.fSource);
        IParserToken token = null;
        if (matcher.find()) {
            token = this.addAllCharactersAsTokenUntilIndex(type, matcher.start(), false);
        }
        return token;
    }

    protected IParserToken addAllCharactersAsTokenUntilIndex(String type, int endIndex, boolean stripTrailingWhitespace) {
        int i;
        if (endIndex > this.fSource.length() || endIndex < 0) {
            throw new IndexOutOfBoundsException(endIndex + ":" + this.fSource.length());
        }
        int adjustedEndIndex = endIndex - 1;
        if (stripTrailingWhitespace) {
            for (i = adjustedEndIndex; i >= 0 && Character.isWhitespace(this.fSource.charAt(i)); --i) {
            }
            adjustedEndIndex = i;
        }
        this.fCharSubSet.delete(0, this.fCharSubSet.length());
        for (i = 0; i <= adjustedEndIndex; ++i) {
            this.fCharSubSet.append(this.fSource.charAt(i));
        }
        this.fSource.delete(0, endIndex);
        IParserToken token = TokenManager.getToken(this.fCharSubSet.length(), this.fOffset, this.fLineNumber, type, this.fCharSubSet.toString());
        this.addToken(token);
        return token;
    }

    protected IParserToken addNonPrefixedHexToken(String type) {
        Matcher matcher = CommonPatternMatchers.hex;
        matcher.reset(this.fSource);
        IParserToken token = null;
        if (matcher.find()) {
            this.fCharSubSet.delete(0, this.fCharSubSet.length());
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            this.fCharSubSet.append('0');
            this.fCharSubSet.append('x');
            for (int i = startIndex; i < endIndex; ++i) {
                this.fCharSubSet.append(this.fSource.charAt(i));
            }
            String value = this.fCharSubSet.toString();
            this.fSource.delete(0, endIndex);
            token = this.addToken(type, value);
        }
        return token;
    }

    protected IParserToken addPrefixedHexToken(String type) {
        return this.addToken(type, CommonPatternMatchers.hex_0x);
    }

    private IParserToken internalAddToken(String type, Matcher matcher) {
        String value = null;
        IParserToken token = null;
        int offset = this.fOffset;
        value = this.matchAndConsumeValue(matcher);
        if (value != null) {
            token = TokenManager.getToken(value.length(), offset, this.fLineNumber, type, value);
            this.fTokenList.put(token.getType(), token);
        }
        return token;
    }

    protected String matchAndConsumeValue(Matcher matcher) {
        matcher.reset(this.fSource);
        String value = null;
        if (matcher.find()) {
            value = matcher.group();
            this.fSource.delete(0, matcher.start() + value.length());
        }
        return value;
    }

    protected String consumeCharacters(int startIndex, int endIndex) {
        String value = this.fSource.substring(startIndex, endIndex);
        this.fSource.delete(startIndex, endIndex);
        return value;
    }

    protected boolean consumeUntilFirstMatch(Matcher matcher) {
        matcher.reset(this.fSource);
        boolean matched = false;
        matched = matcher.find();
        if (matched) {
            this.fSource.delete(0, matcher.end());
        }
        return matched;
    }

    protected boolean findFirst(Matcher matcher) {
        matcher.reset(this.fSource);
        return matcher.find();
    }

    protected int indexOfLast(Matcher matcher) {
        int startingIndex = -1;
        matcher.reset(this.fSource);
        while (matcher.find()) {
            startingIndex = matcher.start();
        }
        return startingIndex;
    }
}

