/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.platform;

import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.platform.IPlatformTypes;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;

public class PlatformSectionParser
extends SectionParser
implements IPlatformTypes {
    private IImageAddressSpaceBuilder fImageAddressSpaceBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public PlatformSectionParser() {
        super("GPINFO");
    }

    @Override
    protected void topLevelRule() throws ParserException {
        this.fImageAddressSpaceBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder();
        if (this.fImageAddressSpaceBuilder != null) {
            this.fImageProcessBuilder = this.fImageAddressSpaceBuilder.getCurrentImageProcessBuilder();
        }
        this.hostInfo();
        this.crashInfo();
        this.moduleInfo();
        this.registerInfo();
        this.moduleInfo();
        this.parseEnvironmentVars();
    }

    private void hostInfo() throws ParserException {
        IAttributeValueMap results = null;
        results = this.processTagLineOptional("2XHHOSTNAME");
        if (results != null) {
            String host_name = results.getTokenValue("platform_host_name");
            String host_addr = results.getTokenValue("platform_host_addr");
            if (host_name != null) {
                this.fImageBuilder.setHostName(host_name);
            }
            if (host_addr != null) {
                try {
                    InetAddress addr = InetAddress.getByName(host_addr);
                    this.fImageBuilder.addHostAddr(addr);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        if ((results = this.processTagLineRequired("2XHOSLEVEL")) != null) {
            String os_name = results.getTokenValue("platform_os_name");
            String os_version = results.getTokenValue("platform_os_version");
            this.fImageBuilder.setOSType(os_name);
            this.fImageBuilder.setOSSubType(os_version);
        }
        this.processTagLineRequired("2XHCPUS");
        results = this.processTagLineRequired("3XHCPUARCH");
        if (results != null) {
            String cpu_arch = results.getTokenValue("platform_cpu_arch");
            this.fImageBuilder.setcpuType(cpu_arch);
        }
        if ((results = this.processTagLineRequired("3XHNUMCPUS")) != null) {
            int cpu_count = results.getIntValue("platform_cpu_count");
            this.fImageBuilder.setcpuCount(cpu_count);
        }
        this.processTagLineOptional("3XHNUMASUP");
    }

    private void crashInfo() throws ParserException {
        IAttributeValueMap results;
        while ((results = this.processTagLineOptional("1XHEXCPCODE")) != null) {
            String value;
            IParserToken token = results.getToken("platform_signal");
            if (token == null || !(value = token.getValue()).startsWith("0x")) continue;
            try {
                int signal = Integer.parseUnsignedInt(value.substring(2), 16);
                if (signal == -1) continue;
                this.fImageProcessBuilder.setSignal(signal);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.processTagLineOptional("1XHERROR2");
    }

    private void moduleInfo() throws ParserException {
        IAttributeValueMap results;
        String moduleName = null;
        long moduleBase = -1L;
        while ((results = this.processTagLineOptional("1XHEXCPMODULE")) != null) {
            long base;
            String name = results.getTokenValue("platform_module_name");
            if (name != null) {
                moduleName = name;
            }
            if ((base = results.getLongValue("platform_module_base")) != -1L) {
                moduleBase = base;
            }
            if (moduleName == null || moduleBase == -1L) continue;
            this.fImageProcessBuilder.addLibrary(moduleName);
            moduleName = null;
            moduleBase = -1L;
        }
    }

    private void registerInfo() throws ParserException {
        if (this.processTagLineOptional("1XHREGISTERS") != null) {
            IAttributeValueMap results;
            LinkedHashMap<String, Short> m = new LinkedHashMap<String, Short>();
            while ((results = this.processTagLineOptional("2XHREGISTER")) != null) {
                String name = results.getTokenValue("platform_register_name");
                String value = results.getTokenValue("platform_register_value");
                Number n = null;
                if (value != null) {
                    String digits = value.regionMatches(true, 0, "0x", 0, 2) ? value.substring(2) : value;
                    BigInteger bigN = new BigInteger(digits, 16);
                    int bits = bigN.bitLength();
                    n = bits <= 16 ? (Number)((short)bigN.intValue()) : (Number)(bits <= 32 ? (Number)bigN.intValue() : (Number)(bits <= 64 ? Long.valueOf(bigN.longValue()) : bigN));
                }
                m.put(name, (Short)n);
            }
            this.fImageProcessBuilder.setRegisters(m);
        }
    }

    private void parseEnvironmentVars() throws ParserException {
        IAttributeValueMap results = null;
        results = this.processTagLineOptional("1XHENVVARS");
        if (results != null) {
            while ((results = this.processTagLineOptional("1XHENVVAR")) != null) {
                String env_name = results.getTokenValue("environment_variable_name");
                String env_value = results.getTokenValue("environment_variable_value");
                if (env_name == null) continue;
                this.fImageProcessBuilder.addEnvironmentVariable(env_name, env_value);
            }
        }
    }

    @Override
    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

