/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;

public class PHDCorruptData
implements CorruptData {
    private final String reason;
    private final ImagePointer address;
    private final Exception cause;

    PHDCorruptData(ImageAddressSpace space, CorruptDataException e) {
        this(e.getCorruptData().toString(), PHDCorruptData.convPointer(space, e.getCorruptData().getAddress()), e);
    }

    PHDCorruptData(ImageAddressSpace space, CorruptData cd) {
        this(cd.toString(), PHDCorruptData.convPointer(space, cd.getAddress()));
    }

    PHDCorruptData(String desc, ImagePointer addr) {
        this(desc, addr, null);
    }

    PHDCorruptData(String desc, ImagePointer addr, Exception exc) {
        this.reason = desc;
        this.address = addr;
        this.cause = exc;
    }

    @Override
    public ImagePointer getAddress() {
        return this.address;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.reason != null) {
            buf.append(this.reason);
        }
        if (this.address != null) {
            if (buf.length() > 0) {
                buf.append(" at ");
            }
            buf.append("0x").append(Long.toHexString(this.address.getAddress()));
        }
        if (this.cause != null) {
            if (buf.length() > 0) {
                buf.append(": ");
            }
            buf.append(this.cause);
        }
        return buf.toString();
    }

    static CorruptDataException newCorruptDataException(PHDCorruptData cd) {
        CorruptDataException e = new CorruptDataException(cd);
        cd.initCause(e);
        return e;
    }

    CorruptDataException initCause(CorruptDataException t) {
        if (this.cause != null) {
            t.initCause(this.cause);
        }
        return t;
    }

    private static ImagePointer convPointer(ImageAddressSpace space, ImagePointer p) {
        if (p != null) {
            return space.getPointer(p.getAddress());
        }
        return null;
    }
}

