/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptJavaThread;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import java.util.ArrayList;
import java.util.Iterator;

public class PHDJavaMonitor
implements JavaMonitor {
    private ImagePointer id;
    private String name;
    private CorruptData name_cd;
    private JavaObject object;
    private JavaThread owner;
    private CorruptData owner_cd;
    private ArrayList<JavaThread> enterWaiters = new ArrayList();
    private ArrayList<JavaThread> notifyWaiters = new ArrayList();

    PHDJavaMonitor(ImageAddressSpace space, PHDJavaRuntime runtime, JavaMonitor source) {
        PHDCorruptJavaThread thr;
        Object next;
        this.id = space.getPointer(source.getID().getAddress());
        try {
            this.name = source.getName();
        }
        catch (CorruptDataException e) {
            this.name_cd = new PHDCorruptData(space, e);
        }
        JavaObject obj = source.getObject();
        if (obj != null) {
            try {
                this.object = runtime.getObjectAtAddress(space.getPointer(obj.getID().getAddress()));
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (DataUnavailable dataUnavailable) {
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
        }
        try {
            JavaThread thr2 = source.getOwner();
            if (thr2 != null) {
                this.owner = runtime.getThread(thr2);
            }
        }
        catch (CorruptDataException e) {
            this.owner_cd = new PHDCorruptData(space, e);
        }
        Iterator it = source.getEnterWaiters();
        while (it.hasNext()) {
            next = it.next();
            if (next instanceof CorruptData) {
                thr = new PHDCorruptJavaThread(space, (CorruptData)next);
                this.enterWaiters.add(thr);
                continue;
            }
            this.enterWaiters.add(runtime.getThread((JavaThread)next));
        }
        it = source.getNotifyWaiters();
        while (it.hasNext()) {
            next = it.next();
            if (next instanceof CorruptData) {
                thr = new PHDCorruptJavaThread(space, (CorruptData)next);
                this.notifyWaiters.add(thr);
                continue;
            }
            this.notifyWaiters.add(runtime.getThread((JavaThread)next));
        }
    }

    @Override
    public Iterator<JavaThread> getEnterWaiters() {
        return this.enterWaiters.iterator();
    }

    @Override
    public ImagePointer getID() {
        return this.id;
    }

    @Override
    public String getName() throws CorruptDataException {
        if (this.name_cd != null) {
            throw new CorruptDataException(this.name_cd);
        }
        return this.name;
    }

    @Override
    public Iterator<JavaThread> getNotifyWaiters() {
        return this.notifyWaiters.iterator();
    }

    @Override
    public JavaObject getObject() {
        return this.object;
    }

    @Override
    public JavaThread getOwner() throws CorruptDataException {
        if (this.owner_cd != null) {
            throw new CorruptDataException(this.owner_cd);
        }
        return this.owner;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.id == ((PHDJavaMonitor)o).id;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }
}

