/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.parser;

import com.ibm.dtfj.phd.parser.Base;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class HeapdumpWriter
extends Base {
    String filename;
    DataOutputStream dos;
    Vector strings = new Vector();
    int lastAddress;
    int[] classAddressCache = new int[4];
    int classAddressCacheIndex;
    public int totalObjects;
    public int totalRefs;
    public int version;
    int[] counts = new int[256];
    int biggestGap;
    int totalGap;
    int where;
    public static final int START_OF_HEADER = 1;
    public static final int START_OF_DUMP = 2;
    public static final int END_OF_DUMP = 3;
    public static final int LONG_OBJECT_RECORD = 4;
    public static final int OBJECT_ARRAY_RECORD = 5;
    public static final int CLASS_RECORD = 6;
    public static final int PRIMITIVE_ARRAY_RECORD = 7;
    public static final int NEW_OBJECT_ARRAY_RECORD = 8;
    public static final int TOTALS = 1;
    public static final int END_OF_HEADER = 2;
    public static final int HASHCODE_RANDOMS = 3;
    public static final int FULL_VERSION = 4;

    public HeapdumpWriter(String filename) {
        this.filename = filename;
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            this.dos = new DataOutputStream(bos);
            this.dos.writeUTF("portable heap dump");
            this.dos.writeInt(4);
            this.dos.writeInt(0);
            this.dos.writeByte(1);
            this.dos.writeByte(1);
            this.dos.writeInt(this.totalObjects);
            this.dos.writeInt(this.totalRefs);
            this.dos.writeByte(2);
            this.dos.writeByte(2);
        }
        catch (Exception e) {
            throw new Error("unexpected error: " + e);
        }
    }

    public void close() {
        try {
            this.dos.writeByte(3);
            this.dos.close();
            RandomAccessFile raf = new RandomAccessFile(this.filename, "rw");
            raf.readUTF();
            raf.readInt();
            raf.readInt();
            raf.readByte();
            raf.readByte();
            raf.writeInt(this.totalObjects);
            raf.writeInt(this.totalRefs);
            raf.close();
        }
        catch (Exception e) {
            throw new Error("unexpected error while closing file" + e);
        }
    }

    int refsSize(int address, int[] refs) {
        if (refs == null) {
            return 0;
        }
        int biggestGap = 0;
        for (int i = 0; i < refs.length; ++i) {
            int gap = Math.abs(address - refs[i]) >> 3;
            if (gap <= biggestGap) continue;
            biggestGap = gap;
        }
        if (biggestGap < 128) {
            return 0;
        }
        if (biggestGap < 32768) {
            return 1;
        }
        return 2;
    }

    void writeRefs(int address, int[] refs, int refsSize) throws IOException {
        int numRefs = refs == null ? 0 : refs.length;
        for (int i = 0; i < numRefs; ++i) {
            int gap = refs[i] - address >> 3;
            if (refsSize == 0) {
                this.dos.writeByte(gap);
                continue;
            }
            if (refsSize == 1) {
                this.dos.writeShort(gap);
                continue;
            }
            if (refsSize == 2) {
                this.dos.writeInt(gap);
                continue;
            }
            if (refsSize != 3) continue;
            this.dos.writeLong(gap);
        }
    }

    void addToCache(int classAddress) {
        this.classAddressCache[this.classAddressCacheIndex] = classAddress;
        this.classAddressCacheIndex = (this.classAddressCacheIndex + 1) % 4;
    }

    public void objectDump(int address, int classAddress, int[] refs) {
        if ((address & 7) != 0 || (classAddress & 7) != 0) {
            return;
        }
        HeapdumpWriter.Assert((address & 7) == 0);
        HeapdumpWriter.Assert((classAddress & 7) == 0);
        int gap = address - this.lastAddress >> 3;
        int absgap = Math.abs(gap);
        int numRefs = refs == null ? 0 : refs.length;
        int refsSize = this.refsSize(address, refs);
        ++this.totalObjects;
        this.totalRefs += numRefs;
        try {
            if (absgap < 32768) {
                int cacheIndex = -1;
                if (classAddress == this.classAddressCache[0]) {
                    cacheIndex = 0;
                } else if (classAddress == this.classAddressCache[1]) {
                    cacheIndex = 1;
                } else if (classAddress == this.classAddressCache[2]) {
                    cacheIndex = 2;
                } else if (classAddress == this.classAddressCache[3]) {
                    cacheIndex = 3;
                }
                if (cacheIndex != -1 && numRefs < 4) {
                    int tag = 128;
                    tag |= cacheIndex << 5;
                    tag |= numRefs << 3;
                    if (absgap >= 128) {
                        tag |= 4;
                    }
                    this.dos.writeByte(tag |= refsSize);
                    if (absgap >= 128) {
                        this.dos.writeShort(gap);
                    } else {
                        this.dos.writeByte(gap);
                    }
                    this.writeRefs(address, refs, refsSize);
                    this.lastAddress = address;
                    return;
                }
                if (numRefs < 8) {
                    int tag = 64;
                    tag |= numRefs << 3;
                    if (absgap >= 128) {
                        tag |= 4;
                    }
                    this.dos.writeByte(tag |= refsSize);
                    if (absgap >= 128) {
                        this.dos.writeShort(gap);
                    } else {
                        this.dos.writeByte(gap);
                    }
                    this.dos.writeInt(classAddress);
                    this.writeRefs(address, refs, refsSize);
                    this.addToCache(classAddress);
                    this.lastAddress = address;
                    return;
                }
            }
            this.dos.writeByte(4);
            int flags = refsSize << 4;
            if (absgap >= 32768) {
                this.dos.writeByte(flags | 0x80);
                this.dos.writeInt(gap);
            } else if (absgap >= 128) {
                this.dos.writeByte(flags | 0x40);
                this.dos.writeShort(gap);
            } else {
                this.dos.writeByte(flags);
                this.dos.writeByte(gap);
            }
            this.dos.writeInt(classAddress);
            this.dos.writeInt(numRefs);
            this.writeRefs(address, refs, refsSize);
            this.addToCache(classAddress);
            this.lastAddress = address;
        }
        catch (IOException e) {
            throw new Error("unexpected error " + e);
        }
    }

    public void classDump(int address, int superAddress, String name, int instanceSize, int[] refs) {
        HeapdumpWriter.Assert((address & 7) == 0);
        int gap = address - this.lastAddress >> 3;
        int absgap = Math.abs(gap);
        int numRefs = refs == null ? 0 : refs.length;
        int refsSize = this.refsSize(address, refs);
        try {
            this.dos.writeByte(6);
            int flags = refsSize << 4;
            if (absgap >= 32768) {
                this.dos.writeByte(flags | 0x80);
                this.dos.writeInt(gap);
            } else if (absgap >= 128) {
                this.dos.writeByte(flags | 0x40);
                this.dos.writeShort(gap);
            } else {
                this.dos.writeByte(flags);
                this.dos.writeByte(gap);
            }
            this.dos.writeInt(instanceSize);
            this.dos.writeInt(superAddress);
            this.dos.writeUTF(name);
            this.dos.writeInt(numRefs);
            this.writeRefs(address, refs, refsSize);
            this.lastAddress = address;
            ++this.totalObjects;
            this.totalRefs += numRefs;
        }
        catch (IOException e) {
            throw new Error("unexpected error " + e);
        }
    }

    public void objectArrayDump(int address, int classAddress, int[] refs) {
        HeapdumpWriter.Assert((address & 7) == 0);
        HeapdumpWriter.Assert((classAddress & 7) == 0);
        int gap = address - this.lastAddress >> 3;
        int absgap = Math.abs(gap);
        int numRefs = refs == null ? 0 : refs.length;
        int refsSize = this.refsSize(address, refs);
        try {
            this.dos.writeByte(5);
            int flags = refsSize << 4;
            if (absgap >= 32768) {
                this.dos.writeByte(flags | 0x80);
                this.dos.writeInt(gap);
            } else if (absgap >= 128) {
                this.dos.writeByte(flags | 0x40);
                this.dos.writeShort(gap);
            } else {
                this.dos.writeByte(flags);
                this.dos.writeByte(gap);
            }
            this.dos.writeInt(classAddress);
            this.dos.writeInt(numRefs);
            this.writeRefs(address, refs, refsSize);
            this.lastAddress = address;
            ++this.totalObjects;
            this.totalRefs += numRefs;
        }
        catch (IOException e) {
            throw new Error("unexpected error " + e);
        }
    }

    public void primitiveArrayDump(int address, int type, int length) {
        HeapdumpWriter.Assert((address & 7) == 0);
        if (type >= 8) {
            type -= 8;
        }
        HeapdumpWriter.Assert(type < 8);
        HeapdumpWriter.Assert(type >= 0);
        int gap = address - this.lastAddress >> 3;
        int absgap = Math.abs(gap);
        try {
            if (absgap >= 32768 || length >= 32768) {
                this.dos.writeByte(0x20 | type << 2 | 2);
                this.dos.writeInt(gap);
                this.dos.writeInt(length);
            } else if (absgap >= 128 || length >= 128) {
                this.dos.writeByte(0x20 | type << 2 | 1);
                this.dos.writeShort(gap);
                this.dos.writeShort(length);
            } else {
                this.dos.writeByte(0x20 | type << 2 | 0);
                this.dos.writeByte(gap);
                this.dos.writeByte(length);
            }
            this.lastAddress = address;
            ++this.totalObjects;
        }
        catch (IOException e) {
            throw new Error("unexpected error " + e);
        }
    }

    @Override
    String className() {
        return "HeapdumpWriter";
    }
}

