/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommandParser {
    private String originalLine;
    private List<String> allTokens = new ArrayList<String>();
    private String command;
    private List<String> arguments = new ArrayList<String>();
    private String redirectionFilename;
    private boolean isAppendToFile;
    private boolean isRedirectedToFile;

    public CommandParser(String commandLine) throws ParseException {
        this.originalLine = commandLine;
        this.tokenise(commandLine);
        this.parse(this.allTokens);
    }

    public CommandParser(String command, String[] arguments) throws ParseException {
        ArrayList<String> allTokens = new ArrayList<String>();
        allTokens.add(command);
        allTokens.addAll(Arrays.asList(arguments));
        this.originalLine = command;
        for (String arg : arguments) {
            this.originalLine = this.originalLine + " " + arg;
        }
        this.parse(allTokens);
    }

    public String toString() {
        return this.originalLine;
    }

    public String getOriginalLine() {
        return this.originalLine;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isRedirectedToFile() {
        return this.isRedirectedToFile || this.isAppendToFile;
    }

    public String[] getArguments() {
        return this.arguments.toArray(new String[0]);
    }

    public PrintStream getOutputFile() throws IOException {
        String parentDirectories;
        File dir;
        if (!this.isRedirectedToFile && !this.isAppendToFile) {
            throw new IllegalStateException("Attempt to create output file for a command which does not contain file redirection.");
        }
        PrintStream outStream = null;
        File outFile = new File(this.redirectionFilename);
        if (this.redirectionFilename.indexOf(File.separator) > -1 && !(dir = new File(parentDirectories = this.redirectionFilename.substring(0, this.redirectionFilename.lastIndexOf(File.separator)))).exists() && !dir.mkdirs()) {
            throw new IOException("Could not create some of the requested directories: " + parentDirectories);
        }
        outStream = this.isAppendToFile && outFile.exists() ? new PrintStream(new FileOutputStream(outFile, true)) : new PrintStream(outFile);
        return outStream;
    }

    private void tokenise(String commandLine) throws ParseException {
        char[] characters = commandLine.toCharArray();
        int i = 0;
        TokenisingState currentState = new GenericTokenState(this);
        do {
            currentState = currentState.process(Character.valueOf(characters[i++]));
            if (i != characters.length) continue;
            currentState.endOfInput();
        } while (i < characters.length);
    }

    private void parse(List<String> allTokens) throws ParseException {
        int i;
        if (allTokens.size() == 0) {
            return;
        }
        this.command = allTokens.get(0);
        for (i = 1; i < allTokens.size() && !allTokens.get(i).equals(">") && !allTokens.get(i).equals(">>"); ++i) {
            this.arguments.add(allTokens.get(i));
        }
        if (i < allTokens.size()) {
            if (allTokens.get(i).equals(">")) {
                this.isAppendToFile = false;
                this.isRedirectedToFile = true;
            } else {
                this.isAppendToFile = true;
                this.isRedirectedToFile = false;
            }
            if (i + 1 < allTokens.size()) {
                String filename = allTokens.get(i + 1).trim();
                if (filename.charAt(filename.length() - 1) == File.separatorChar) {
                    throw new ParseException("Invalid redirection path - missing filename", i);
                }
                this.redirectionFilename = allTokens.get(i + 1);
            } else {
                throw new ParseException("Missing file name for redirection", i);
            }
        }
    }

    class FilenameState
    extends TokenisingState {
        private Character quoteType;
        private boolean alreadyStarted;
        private boolean alreadyFinished;

        protected FilenameState(CommandParser context) {
            super(context);
            this.quoteType = null;
            this.alreadyStarted = false;
            this.alreadyFinished = false;
        }

        @Override
        protected TokenisingState process(Character chr) throws ParseException {
            if (this.alreadyFinished) {
                throw new ParseException("Only one file name is permitted", 0);
            }
            if (!this.alreadyStarted) {
                if (chr.equals(Character.valueOf('\"')) || chr.equals(Character.valueOf('\''))) {
                    this.quoteType = chr;
                } else {
                    this.currentToken.append(chr);
                }
                this.alreadyStarted = true;
            } else if (chr.equals(this.quoteType)) {
                this.storeToken();
                this.alreadyFinished = true;
            } else if (Character.isWhitespace(chr.charValue())) {
                if (this.quoteType != null) {
                    this.currentToken.append(chr);
                } else {
                    this.storeToken();
                    this.alreadyFinished = true;
                }
            } else {
                this.currentToken.append(chr);
            }
            return this;
        }

        @Override
        protected void endOfInput() throws ParseException {
            if (!this.alreadyStarted) {
                throw new ParseException("Missing file name", 0);
            }
            if (this.alreadyStarted && !this.alreadyFinished && this.quoteType != null) {
                throw new ParseException("Unmatched " + this.quoteType + " in file name", 0);
            }
            this.storeToken();
        }
    }

    class QuotedStringState
    extends TokenisingState {
        private Character quoteType;
        private boolean escape;

        protected QuotedStringState(CommandParser context, Character quoteType) {
            super(context);
            this.escape = false;
            this.quoteType = quoteType;
        }

        @Override
        protected TokenisingState process(Character chr) throws ParseException {
            switch (chr.charValue()) {
                case '\\': {
                    if (this.escape) {
                        this.currentToken.append(chr);
                        this.escape = false;
                    } else {
                        this.escape = true;
                    }
                    return this;
                }
                case '\"': 
                case '\'': {
                    if (chr != this.quoteType) {
                        this.currentToken.append(chr);
                        return this;
                    }
                    if (this.escape) {
                        this.currentToken.append(chr);
                        this.escape = false;
                        return this;
                    }
                    this.storeToken();
                    return new GenericTokenState(this.context);
                }
            }
            if (this.escape) {
                this.currentToken.append("\\");
                this.escape = false;
            }
            this.currentToken.append(chr);
            return this;
        }

        @Override
        protected void endOfInput() throws ParseException {
            if (this.currentToken.length() > 0) {
                throw new ParseException("Unmatched " + this.quoteType, 0);
            }
        }
    }

    class GenericTokenState
    extends TokenisingState {
        protected GenericTokenState(CommandParser context) {
            super(context);
        }

        @Override
        protected TokenisingState process(Character chr) throws ParseException {
            if (Character.isWhitespace(chr.charValue())) {
                if (this.currentToken.toString().equals(">") || this.currentToken.toString().equals(">>")) {
                    this.storeToken();
                    return new FilenameState(this.context);
                }
                this.storeToken();
                return this;
            }
            switch (chr.charValue()) {
                case '\"': 
                case '\'': {
                    if (this.currentToken.length() > 0) {
                        throw new ParseException("'" + chr + "' invalid inside a string", 0);
                    }
                    return new QuotedStringState(this.context, chr);
                }
            }
            this.currentToken.append(chr);
            return this;
        }

        @Override
        protected void endOfInput() {
            this.storeToken();
        }
    }

    abstract class TokenisingState {
        protected CommandParser context;
        protected StringBuilder currentToken = new StringBuilder();

        protected abstract TokenisingState process(Character var1) throws ParseException;

        protected TokenisingState(CommandParser context) {
            this.context = context;
        }

        protected void storeToken() {
            if (this.currentToken.length() > 0) {
                this.context.allTokens.add(this.currentToken.toString());
                this.currentToken = new StringBuilder();
            }
        }

        protected abstract void endOfInput() throws ParseException;
    }
}

