/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.indexsupport;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.j9.JavaHeap;
import com.ibm.dtfj.java.j9.JavaHeapRegion;
import com.ibm.dtfj.java.j9.JavaRuntime;
import com.ibm.jvm.j9.dump.indexsupport.IParserNode;
import com.ibm.jvm.j9.dump.indexsupport.NodeAbstract;
import com.ibm.jvm.j9.dump.indexsupport.NodeObjects;
import com.ibm.jvm.j9.dump.indexsupport.NodeRegion;
import java.util.Vector;
import org.xml.sax.Attributes;

public class NodeHeap
extends NodeAbstract {
    private JavaRuntime _javaVM;
    private Vector _completeRegions = new Vector();
    private JavaHeap _heap;
    private JavaHeapRegion _legacyRegion;
    private long _arrayletLeafSize;

    public NodeHeap(JavaRuntime runtime, Attributes attributes) {
        String name = attributes.getValue("name");
        this._javaVM = runtime;
        boolean isOldFormat = true;
        String idString = attributes.getValue("id");
        String startString = attributes.getValue("start");
        String endString = attributes.getValue("end");
        String alignmentString = attributes.getValue("objectAlignment");
        String minimumObjectSizeString = attributes.getValue("minimumObjectSize");
        if (null == alignmentString || null == minimumObjectSizeString) {
            isOldFormat = false;
        }
        long id = NodeHeap._longFromString(idString);
        long start = NodeHeap._longFromString(startString);
        long end = NodeHeap._longFromString(endString);
        int alignment = (int)NodeHeap._longFromString(alignmentString);
        int minimumObjectSize = (int)NodeHeap._longFromString(minimumObjectSizeString);
        String arrayletLeafSizeString = attributes.getValue("arrayletLeafSize");
        this._arrayletLeafSize = NodeHeap._longFromString(arrayletLeafSizeString);
        String arrayletIdOffsetString = attributes.getValue("arrayletIdOffset");
        int arrayletIdOffset = (int)NodeHeap._longFromString(arrayletIdOffsetString);
        String arrayletIdWidthString = attributes.getValue("arrayletIdWidth");
        int arrayletIdWidth = (int)NodeHeap._longFromString(arrayletIdWidthString);
        String arrayletIdMaskString = attributes.getValue("arrayletIdMask");
        long arrayletIdMask = NodeHeap._longFromString(arrayletIdMaskString);
        String arrayletIdResultString = attributes.getValue("arrayletIdResult");
        long arrayletIdResult = NodeHeap._longFromString(arrayletIdResultString);
        int fobjectSize = (int)NodeHeap._longFromString(attributes.getValue("fobjectSize"), runtime.bytesPerPointer());
        int fobjectPointerScale = (int)NodeHeap._longFromString(attributes.getValue("fobjectPointerScale"), 1L);
        long fobjectPointerDisplacement = NodeHeap._longFromString(attributes.getValue("fobjectPointerDisplacement"));
        int classOffset = (int)NodeHeap._longFromString(attributes.getValue("classOffset"));
        int classSize = (int)NodeHeap._longFromString(attributes.getValue("classPointerSize"), runtime.bytesPerPointer());
        long classAlignment = NodeHeap._longFromString(attributes.getValue("classAlignment"), 0L);
        boolean isSWH = NodeHeap._longFromString(attributes.getValue("SWH"), 0L) >= 1L;
        this._heap = new JavaHeap(runtime, name, runtime.pointerInAddressSpace(id), runtime.pointerInAddressSpace(start), end - start, arrayletIdOffset, arrayletIdWidth, arrayletIdMask, arrayletIdResult, fobjectSize, fobjectPointerScale, fobjectPointerDisplacement, classOffset, classSize, classAlignment, isSWH);
        this._javaVM.addHeap(this._heap);
        if (isOldFormat) {
            String heapBaseString = attributes.getValue("start");
            long heapStart = NodeHeap._longFromString(heapBaseString);
            String heapEndString = attributes.getValue("end");
            long heapEnd = NodeHeap._longFromString(heapEndString);
            this._legacyRegion = this.createJavaHeapRegion(name, id, alignment, minimumObjectSize, heapStart, heapEnd);
            this._completeRegions.add(this._legacyRegion);
        }
    }

    @Override
    public IParserNode nodeToPushAfterStarting(String uri, String localName, String qName, Attributes attributes) {
        IParserNode child = null;
        if (qName.equals("region")) {
            if (null != this._legacyRegion) {
                throw new IllegalStateException("Legacy heap region must be null for new world XML shape");
            }
            child = new NodeRegion(this, attributes);
        } else if (qName.equals("objects")) {
            if (null == this._legacyRegion) {
                throw new IllegalStateException("Legacy heap region cannot be null for legacy XML shape");
            }
            child = new NodeObjects(this._legacyRegion, attributes);
        } else {
            child = super.nodeToPushAfterStarting(uri, localName, qName, attributes);
        }
        return child;
    }

    @Override
    public void didFinishParsing() {
        this._heap.setRegions(this._completeRegions);
    }

    public JavaHeapRegion createJavaHeapRegion(String name, long id, int objectAlignment, int minimumObjectSize, long heapStart, long heapEnd) {
        ImagePointer basePointer = null;
        if (0L != heapStart) {
            basePointer = this._javaVM.pointerInAddressSpace(heapStart);
        }
        return new JavaHeapRegion(this._javaVM, name, this._javaVM.pointerInAddressSpace(id), objectAlignment, minimumObjectSize, this._arrayletLeafSize, this._heap, basePointer, heapEnd - heapStart);
    }

    public void addRegion(JavaHeapRegion region) {
        this._completeRegions.add(region);
    }
}

