/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.indexsupport;

import com.ibm.dtfj.corereaders.ResourceReleaser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XMLInputStream
extends InputStream
implements ResourceReleaser {
    private InputStream in = null;
    private static final int BUFFER_SIZE = 4096;
    private char[] buffer = new char[4096];
    private InputStreamReader reader = null;
    private OutputStreamWriter writer = null;
    private int index = 0;
    private int indexMax = 0;
    private boolean eos = false;
    private static final String CHARSET_NAME = "UTF-8";
    private int[] utf8Data = new int[3];
    private int utf8Index = 0;
    private int utf8MaxIndex = -1;
    private static final int STATE_START_TAG = 1;
    private static final int STATE_CLOSE_TAG = 2;
    private static final int STATE_CONTENTS = 3;
    private static final int STATE_ATTRIBUTES = 4;
    private static final int STATE_ATTRIBUTE_CONTENTS = 5;
    private static final int STATE_INSERT_MISSING_CLOSING_TAG = 6;
    private static final int STATE_INSERT_MISSING_CLOSING_TAG_ROOT = 7;
    private int state = 3;
    private Stack tags = new Stack();
    private StringBuffer name = null;
    private String peekName = null;
    private StringBuffer missingDataBuffer = null;
    private int missingDataIndex = 0;
    private Logger log = Logger.getLogger(this.getClass().getName());
    private boolean outputWritten = false;
    private File temp = null;
    private FileOutputStream fout = null;

    public XMLInputStream(InputStream in) {
        this.log.fine("Cleaning xml input stream");
        this.in = in;
        try {
            this.reader = new InputStreamReader(in, CHARSET_NAME);
            this.writer = new OutputStreamWriter(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    ((XMLInputStream)XMLInputStream.this).utf8Data[++((XMLInputStream)XMLInputStream.this).utf8MaxIndex] = b;
                }
            }, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            this.log.log(Level.WARNING, "Could not create an UTF-8 reader", e);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            try {
                this.temp = File.createTempFile("dtfj", ".txt");
                this.fout = new FileOutputStream(this.temp);
            }
            catch (Exception e) {
                this.log.warning("Could not create temporary file to log the output");
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.reader == null) {
            return this.in.read();
        }
        if (this.utf8Index <= this.utf8MaxIndex) {
            return this.utf8Data[this.utf8Index++];
        }
        if (this.eos) {
            return -1;
        }
        char data = this.getData();
        if (this.eos) {
            return -1;
        }
        this.utf8MaxIndex = -1;
        this.writer.write(data);
        this.writer.flush();
        this.utf8Index = 0;
        if (this.log.isLoggable(Level.FINEST)) {
            this.fout.write(data);
        }
        return this.utf8Data[this.utf8Index++];
    }

    private char getData() throws IOException {
        char nextChar = this.readNextChar();
        if (this.eos) {
            return '\u0000';
        }
        switch (this.state) {
            case 1: {
                return this.doStartTag(nextChar);
            }
            case 6: 
            case 7: {
                return this.doMissingClosingTag(nextChar);
            }
            case 4: {
                return this.doAttributes(nextChar);
            }
            case 5: {
                return this.doAttributeContents(nextChar);
            }
            case 3: {
                return this.doTagContents(nextChar);
            }
            case 2: {
                return this.doCloseTag(nextChar);
            }
        }
        throw new IllegalStateException("An unknown state of " + this.state + " was encountered");
    }

    private char doCloseTag(char data) throws IOException {
        if (data == '>') {
            this.state = 3;
            this.doStackIntegrityCheck(this.tags.pop());
        } else {
            this.name.append(data);
        }
        return data;
    }

    private char doTagContents(char data) throws IOException {
        if (data == '<') {
            if (!this.tags.isEmpty()) {
                this.peekName = this.peekTagFromStream(' ');
                char checkInvalidTagNameChar = this.peekName.charAt(0);
                if ('!' == checkInvalidTagNameChar || '?' == checkInvalidTagNameChar) {
                    return data;
                }
                if (this.tags.peek().equals(this.peekName)) {
                    this.missingDataIndex = 0;
                    this.missingDataBuffer = new StringBuffer();
                    this.missingDataBuffer.append("/");
                    this.missingDataBuffer.append(this.tags.peek());
                    this.missingDataBuffer.append("><");
                    this.tags.pop();
                    this.state = 7;
                    return data;
                }
            }
            this.state = 1;
            this.name = new StringBuffer();
        }
        return data;
    }

    private char doAttributeContents(char data) throws IOException {
        if (data == '\"' || data == '\'') {
            this.state = 4;
        }
        return data;
    }

    private char doMissingClosingTag(char data) throws IOException {
        if (this.missingDataIndex == this.missingDataBuffer.length()) {
            switch (this.state) {
                case 6: {
                    this.state = 2;
                    break;
                }
                case 7: {
                    this.state = 1;
                    this.name = new StringBuffer();
                    break;
                }
            }
        }
        return data;
    }

    private char doAttributes(char data) throws IOException {
        switch (data) {
            case '/': {
                this.state = 3;
                this.doStackIntegrityCheck(this.tags.pop());
                break;
            }
            case '>': {
                this.state = 3;
                break;
            }
            case '\"': 
            case '\'': {
                this.state = 5;
                break;
            }
        }
        return data;
    }

    private char doStartTag(char data) throws IOException {
        String tag = null;
        switch (data) {
            case ' ': {
                tag = this.name.toString();
                this.tags.push(tag);
                this.state = 4;
                break;
            }
            case '/': {
                this.peekName = this.peekTagFromStream('>');
                if (this.peekName.equals(this.tags.peek())) {
                    this.state = 2;
                    break;
                }
                this.missingDataIndex = 0;
                this.missingDataBuffer = new StringBuffer();
                do {
                    tag = (String)this.tags.pop();
                    this.missingDataBuffer.append(tag);
                    this.missingDataBuffer.append("></");
                } while (!this.tags.peek().equals(this.peekName));
                this.state = 6;
                break;
            }
            case '!': 
            case '?': {
                this.state = 3;
                break;
            }
            default: {
                this.name.append(data);
            }
        }
        return data;
    }

    private char readNextChar() throws IOException {
        switch (this.state) {
            case 6: 
            case 7: {
                return this.missingDataBuffer.charAt(this.missingDataIndex++);
            }
        }
        return this.readFromBuffer();
    }

    private String peekTagFromStream(char delimeter) throws IOException {
        try {
            int peek = this.index;
            String tag = (String)this.tags.peek();
            int unreadDataLength = this.availableBufferDataLength();
            if (tag.length() > unreadDataLength) {
                System.arraycopy(this.buffer, this.index, this.buffer, 0, unreadDataLength);
                this.putDataIntoBuffer(unreadDataLength);
                peek = 0;
            }
            while (peek < this.indexMax && this.buffer[peek] != delimeter) {
                ++peek;
            }
            return new String(this.buffer, this.index, peek - this.index);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Failed to peek the next tag from the stream", e);
            return "";
        }
    }

    private void doStackIntegrityCheck(Object popped) {
        String currentTag = this.name.toString();
        if (!currentTag.equals(popped)) {
            this.log.severe("Tag mismatch : processing " + currentTag + " but stack top is " + popped);
        }
    }

    private int availableBufferDataLength() {
        return this.indexMax - this.index;
    }

    private char readFromBuffer() throws IOException {
        if (this.index == this.indexMax) {
            this.putDataIntoBuffer(0);
            if (this.eos) {
                return '\u0000';
            }
        }
        return this.buffer[this.index++];
    }

    private void putDataIntoBuffer(int startIndex) throws IOException {
        int count = this.reader.read(this.buffer, startIndex, 4096 - startIndex);
        if (count == -1) {
            this.eos = true;
            this.indexMax = -1;
        } else {
            this.indexMax = startIndex + count;
            this.index = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        if (this.log.isLoggable(Level.FINEST) && !this.outputWritten) {
            this.fout.close();
            this.log.finest("Output sent to file " + this.temp.getAbsolutePath() + "\n");
            this.outputWritten = true;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void releaseResources() {
        try {
            this.close();
        }
        catch (IOException e) {
            Logger.getLogger("com.ibm.dtfj.log").log(Level.WARNING, e.getMessage(), e);
        }
    }
}

