/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.net.IDN;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;

public final class SNIHostName
extends SNIServerName {
    private final String d;
    private static final String[] f;

    public SNIHostName(String string) {
        string = IDN.toASCII(Objects.requireNonNull(string, f[0]), 2);
        super(0, string.getBytes(StandardCharsets.US_ASCII));
        this.d = string;
        this.a();
    }

    public SNIHostName(byte[] byArray) {
        super(0, byArray);
        try {
            CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.d = IDN.toASCII(charsetDecoder.decode(ByteBuffer.wrap(byArray)).toString());
        }
        catch (RuntimeException | CharacterCodingException exception) {
            throw new IllegalArgumentException(f[1], exception);
        }
        this.a();
    }

    public String getAsciiName() {
        return this.d;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SNIHostName) {
            return this.d.equalsIgnoreCase(((SNIHostName)object).d);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = 31 * n + this.d.toUpperCase(Locale.ENGLISH).hashCode();
        return n;
    }

    @Override
    public String toString() {
        return f[5] + this.d;
    }

    public static SNIMatcher createSNIMatcher(String string) {
        if (string == null) {
            throw new NullPointerException(f[2]);
        }
        return new SNIHostNameMatcher(string);
    }

    private void a() {
        if (this.d.isEmpty()) {
            throw new IllegalArgumentException(f[3]);
        }
        if (this.d.endsWith(".")) {
            throw new IllegalArgumentException(f[4]);
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[6];
                var3_1 = 0;
                var2_2 = "\u0002Hs:k@{?Ll).D:=XdlaT{9Br8Q\\:<H!/o\\5>Y!.k\u00125$Am(\u0005Edlk\\8>Id(.A>#[d>.\\:<H!:o^.4\rh?.[5'Lm%j%\u0005Edl|W<$A`>.W#!_d?}[4?\rb-`\\4%\rc).\\.=A.\u0002Hs:k@{?Ll).D:=XdlaT{9Br8Q\\:<H!/o\\5>Y!.k\u0012><]u5";
                var4_3 = "\u0002Hs:k@{?Ll).D:=XdlaT{9Br8Q\\:<H!/o\\5>Y!.k\u00125$Am(\u0005Edlk\\8>Id(.A>#[d>.\\:<H!:o^.4\rh?.[5'Lm%j%\u0005Edl|W<$A`>.W#!_d?}[4?\rb-`\\4%\rc).\\.=A.\u0002Hs:k@{?Ll).D:=XdlaT{9Br8Q\\:<H!/o\\5>Y!.k\u0012><]u5".length();
                var1_4 = 45;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0002Hs:k@{?Ll).D:=XdlaT{9Br8Q\\:<H!/o\\5>Y!$oD>qYi).F)0Dm%`U{5Bu\u001a%Tq)3Z4\"Y^\"o_>q\u00051e\"\u0012-0At)3";
                    var4_3 = "\u0002Hs:k@{?Ll).D:=XdlaT{9Br8Q\\:<H!/o\\5>Y!$oD>qYi).F)0Dm%`U{5Bu\u001a%Tq)3Z4\"Y^\"o_>q\u00051e\"\u0012-0At)3".length();
                    var1_4 = 59;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 81;
                            break;
                        }
                        case 1: {
                            v13 = 45;
                            break;
                        }
                        case 2: {
                            v13 = 1;
                            break;
                        }
                        case 3: {
                            v13 = 76;
                            break;
                        }
                        case 4: {
                            v13 = 14;
                            break;
                        }
                        case 5: {
                            v13 = 50;
                            break;
                        }
                        default: {
                            v13 = 91;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        SNIHostName.f = var5;
    }

    private static final class SNIHostNameMatcher
    extends SNIMatcher {
        private final Pattern b;
        private static final String[] d;

        SNIHostNameMatcher(String string) {
            super(0);
            this.b = Pattern.compile(string, 2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean matches(SNIServerName sNIServerName) {
            SNIHostName sNIHostName;
            if (sNIServerName == null) {
                throw new NullPointerException(d[1]);
            }
            if (!(sNIServerName instanceof SNIHostName)) {
                if (sNIServerName.getType() != 0) {
                    throw new IllegalArgumentException(d[0]);
                }
                try {
                    sNIHostName = new SNIHostName(sNIServerName.getEncoded());
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    return false;
                }
            } else {
                sNIHostName = (SNIHostName)sNIServerName;
            }
            String string = sNIHostName.getAsciiName();
            if (this.b.matcher(string).matches()) {
                return true;
            }
            return this.b.matcher(IDN.toUnicode(string)).matches();
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u007f&A#m\u0004\u001a]+V#p\u0000\u0005NnPzn\u0004HB=\u0004mq\u0015HC!WwA\u000f\tF+)\u007f&A#M/!x+Vu{\u0013&J#A#\u007f\u0013\u000f^#AmjA\u000bJ JljA\nNnJvr\r";
                var4_3 = "\u007f&A#m\u0004\u001a]+V#p\u0000\u0005NnPzn\u0004HB=\u0004mq\u0015HC!WwA\u000f\tF+)\u007f&A#M/!x+Vu{\u0013&J#A#\u007f\u0013\u000f^#AmjA\u000bJ JljA\nNnJvr\r".length();
                var1_4 = 37;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                var6_6 = 0;
                v3 = v2.length;
                v4 = v2;
                v5 = v3;
                if (v3 > 1) ** GOTO lbl59
                do {
                    v6 = v4;
                    v7 = v4;
                    v8 = var6_6;
                    while (true) {
                        v9 = v6[v8];
                        switch (var6_6 % 7) {
                            case 0: {
                                v10 = 43;
                                break;
                            }
                            case 1: {
                                v10 = 78;
                                break;
                            }
                            case 2: {
                                v10 = 36;
                                break;
                            }
                            case 3: {
                                v10 = 3;
                                break;
                            }
                            case 4: {
                                v10 = 30;
                                break;
                            }
                            case 5: {
                                v10 = 97;
                                break;
                            }
                            default: {
                                v10 = 104;
                            }
                        }
                        v6[v8] = (char)(v9 ^ v10);
                        ++var6_6;
                        v4 = v7;
                        v5 = v5;
                        if (v5 != 0) break;
                        v7 = v4;
                        v11 = v5;
                        v8 = v5;
                        v6 = v4;
                    }
lbl59:
                    // 2 sources

                    v0 = v4;
                    v11 = v5;
                } while (v5 > var6_6);
                ** while (true)
            }
            SNIHostNameMatcher.d = var5;
        }
    }
}

