/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import ibm.security.internal.spec.RFC5915ECPrivateKeyEncodedKeySpec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECKeyFactory
extends KeyFactorySpi {
    private static final String[] z;

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            return new ECPrivateKey(byArray);
        }
        if (keySpec instanceof ECPrivateKeySpec) {
            ECParameterSpec eCParameterSpec = ((ECPrivateKeySpec)keySpec).getParams();
            BigInteger bigInteger = ((ECPrivateKeySpec)keySpec).getS();
            return new ECPrivateKey(bigInteger, eCParameterSpec);
        }
        if (keySpec instanceof RFC5915ECPrivateKeyEncodedKeySpec) {
            return new ECPrivateKey((RFC5915ECPrivateKeyEncodedKeySpec)keySpec);
        }
        try {
            throw new InvalidKeySpecException(z[14]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                return new ECPublicKey(byArray);
            }
            if (keySpec instanceof ECPublicKeySpec) {
                ECParameterSpec eCParameterSpec = ((ECPublicKeySpec)keySpec).getParams();
                ECPoint eCPoint = ((ECPublicKeySpec)keySpec).getW();
                return new ECPublicKey(eCPoint, eCParameterSpec);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                ECPrivateKey eCPrivateKey = new ECPrivateKey(byArray);
                return eCPrivateKey.getPublicKey();
            }
            if (keySpec instanceof RFC5915ECPrivateKeyEncodedKeySpec) {
                ECPrivateKey eCPrivateKey = new ECPrivateKey((RFC5915ECPrivateKeyEncodedKeySpec)keySpec);
                return eCPrivateKey.getPublicKey();
            }
            throw new InvalidKeySpecException(z[13]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            Class<T> clazz2;
            if (key instanceof java.security.interfaces.ECPrivateKey) {
                clazz2 = Class.forName(z[10]);
                Class<T> clazz3 = Class.forName(z[7]);
                Class<T> clazz4 = Class.forName(z[5]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.ECPrivateKey eCPrivateKey = (java.security.interfaces.ECPrivateKey)key;
                    return (T)((KeySpec)clazz.cast(new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams())));
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
                }
                if (!clazz4.isAssignableFrom(clazz)) {
                    throw new InvalidKeySpecException(z[6]);
                }
                if (key instanceof ECPrivateKey) {
                    return (T)((KeySpec)clazz.cast(new RFC5915ECPrivateKeyEncodedKeySpec(((ECPrivateKey)key).getEncoded(z[8]))));
                }
                try {
                    ECPrivateKey eCPrivateKey = new ECPrivateKey(key.getEncoded());
                    return (T)((KeySpec)clazz.cast(new RFC5915ECPrivateKeyEncodedKeySpec(eCPrivateKey.getEncoded(z[0]))));
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidKeySpecException(invalidKeyException.getMessage());
                }
            }
            if (key instanceof java.security.interfaces.ECPublicKey) {
                clazz2 = Class.forName(z[2]);
                Class<T> clazz5 = Class.forName(z[1]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.ECPublicKey eCPublicKey = (java.security.interfaces.ECPublicKey)key;
                    return (T)((KeySpec)clazz.cast(new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams())));
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
                }
                throw new InvalidKeySpecException(z[3]);
            }
            throw new InvalidKeySpecException(z[4]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[9] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            block8: {
                block9: {
                    block6: {
                        block7: {
                            if (!(key instanceof java.security.interfaces.ECPrivateKey)) break block6;
                            if (!(key instanceof ECPrivateKey)) break block7;
                            return key;
                        }
                        ECPrivateKeySpec eCPrivateKeySpec = this.engineGetKeySpec(key, ECPrivateKeySpec.class);
                        return this.engineGeneratePrivate(eCPrivateKeySpec);
                    }
                    if (!(key instanceof java.security.interfaces.ECPublicKey)) break block8;
                    if (!(key instanceof ECPublicKey)) break block9;
                    return key;
                }
                ECPublicKeySpec eCPublicKeySpec = this.engineGetKeySpec(key, ECPublicKeySpec.class);
                return this.engineGeneratePublic(eCPublicKeySpec);
            }
            throw new InvalidKeyException(z[12]);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(z[11] + invalidKeySpecException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "r\b4m\u0018\u0011{";
        int n3 = -1;
        block22: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                block25: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block25;
                    n5 = n5;
                    if (n5 <= n4) break block26;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 32;
                            break;
                        }
                        case 1: {
                            n6 = 78;
                            break;
                        }
                        case 2: {
                            n6 = 119;
                            break;
                        }
                        case 3: {
                            n6 = 88;
                            break;
                        }
                        default: {
                            n6 = 33;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "J/\u00019\u000fS+\u0014-SI:\u000evRP+\u0014vy\u0015~N\u001dOC!\u0013=Ek+\u000e\u000bQE-";
                    n3 = 0;
                    continue block22;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "J/\u00019\u000fS+\u0014-SI:\u000evRP+\u0014vdc\u001e\u0002:MI-<=Xs>\u0012;";
                    n3 = 1;
                    continue block22;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "i \u0016(QR!\u0007*HA:\u0012xJE7W+QE-\u001e>HC/\u00031NN";
                    n3 = 2;
                    continue block22;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "i \u0016(QR!\u0007*HA:\u0012xJE7W,XP+";
                    n3 = 3;
                    continue block22;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "I,\u001avRE-\u0002*HT7Y1OT+\u00056@L`\u0004(DC`%\u001eb\u0015wFmdc\u001e\u00051WA:\u0012\u0013DY\u000b\u0019;ND+\u0013\u0013DY\u001d\u0007=B";
                    n3 = 4;
                    continue block22;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "i \u0016(QR!\u0007*HA:\u0012xJE7W+QE-\u001e>HC/\u00031NN";
                    n3 = 5;
                    continue block22;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "J/\u00019\u000fS+\u0014-SI:\u000evRP+\u0014vqk\r$`dN-\u0018<DD\u0005\u0012!rP+\u0014";
                    n3 = 6;
                    continue block22;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "r\b4m\u0018\u0011{";
                    n3 = 7;
                    continue block22;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "u \u0004-QP!\u0005,DDn\u001c=X\u0000=\u0007=BI(\u001e;@T'\u00186\u001b\u0000";
                    n3 = 8;
                    continue block22;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "J/\u00019\u000fS+\u0014-SI:\u000evRP+\u0014vdc\u001e\u00051WA:\u0012\u0013DY\u001d\u0007=B";
                    n3 = 9;
                    continue block22;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "c/\u00196NTn\u0003*@N=\u001b9UEn\u001c=X\u001an";
                    n3 = 10;
                    continue block22;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "w<\u00186F\u0000/\u001b?NR'\u00030L\u0000:\u000e(D";
                    n3 = 11;
                    continue block22;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "u \u0004-QP!\u0005,DDn\u001c=X\u0000=\u0007=BI(\u001e;@T'\u00186";
                    n3 = 12;
                    continue block22;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "u \u0004-QP!\u0005,DDn\u001c=X\u0000=\u0007=BI(\u001e;@T'\u00186";
                    n3 = 13;
                    continue block22;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

