/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPublicKey;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.x509.AlgorithmId;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public abstract class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger a;
    static int b;
    static int c;
    private int d = 2048;
    SecureRandom e = null;
    private RSAUtil.KeyType f = RSAUtil.KeyType.RSA;
    private AlgorithmId g;
    private static final String[] z;

    RSAKeyPairGenerator(RSAUtil.KeyType keyType, int n2) {
        this.f = keyType;
        this.initialize(n2, null);
    }

    RSAKeyPairGenerator(int n2) {
        this.f = RSAUtil.KeyType.RSA;
        this.initialize(n2, null);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec2;
        block19: {
            int n2;
            block18: {
                if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                    throw new InvalidAlgorithmParameterException(z[4]);
                }
                RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
                algorithmParameterSpec2 = rSAKeyGenParameterSpec.getKeyParams();
                n2 = rSAKeyGenParameterSpec.getKeysize();
                this.a = rSAKeyGenParameterSpec.getPublicExponent();
                this.e = secureRandom;
                if (n2 % 8 != 0) {
                    throw new InvalidAlgorithmParameterException(z[5]);
                }
                try {
                    RSAKeyFactory.checkKeyLengths(n2, this.a, 512, 65536);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidAlgorithmParameterException(z[2], invalidKeyException);
                }
                this.d = n2;
                if (this.a != null) break block18;
                this.a = RSAKeyGenParameterSpec.F4;
                break block19;
            }
            if (this.a.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException(z[1]);
            }
            if (this.a.bitLength() > n2) {
                throw new InvalidAlgorithmParameterException(z[3]);
            }
        }
        try {
            this.g = RSAUtil.createAlgorithmId((RSAUtil.KeyType)this.f, (AlgorithmParameterSpec)algorithmParameterSpec2);
        }
        catch (ProviderException providerException) {
            throw new InvalidAlgorithmParameterException(z[6], providerException);
        }
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        try {
            this.initialize(new RSAKeyGenParameterSpec(n2, RSAKeyGenParameterSpec.F4), null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    public void initialize(int n2) {
        this.initialize(n2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyPair generateKeyPair() {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        BigInteger bigInteger4;
        int n2;
        if (this.e == null) {
            this.e = null;
            try {
                this.e = SecureRandom.getInstance(z[0]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.e = new SecureRandom();
            }
        }
        BigInteger bigInteger7 = this.a != null ? this.a : RSAKeyGenParameterSpec.F4;
        while ((n2 = (bigInteger4 = (bigInteger6 = new BigInteger(this.d / 2, 10, this.e)).multiply(bigInteger5 = new BigInteger(this.d / 2, 10, this.e))).bitLength()) != this.d || !bigInteger7.gcd(bigInteger = (bigInteger3 = bigInteger6.subtract(BigInteger.ONE)).multiply(bigInteger2 = bigInteger5.subtract(BigInteger.ONE))).equals(BigInteger.ONE)) {
        }
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger2);
        BigInteger bigInteger11 = bigInteger5.modInverse(bigInteger6);
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(this.g, bigInteger4, bigInteger7);
            RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(this.g, bigInteger4, bigInteger8, bigInteger7, bigInteger6, bigInteger5, bigInteger9, bigInteger10, bigInteger11);
            return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0017%/a\f=\u0012\u0010W;?\t\u0006]\u0004";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                block17: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block17;
                    n5 = n5;
                    if (n5 <= n4) break block18;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 94;
                            break;
                        }
                        case 1: {
                            n6 = 103;
                            break;
                        }
                        case 2: {
                            n6 = 98;
                            break;
                        }
                        case 3: {
                            n6 = 50;
                            break;
                        }
                        default: {
                            n6 = 105;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u000e\u0012\u0000^\u0000=G\u0007J\u00191\t\u0007\\\u001d~\n\u0017A\u001d~\u0005\u0007\u0012Z~\b\u0010\u0012\u0005?\u0015\u0005W\u001b";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0017\t\u0014S\u00057\u0003BY\f'G\u0011[\u0013;\u0014";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u000e\u0012\u0000^\u0000=G\u0007J\u00191\t\u0007\\\u001d~\n\u0017A\u001d~\u0005\u0007\u0012\u001a3\u0006\u000e^\f,G\u0016Z\b0G\tW\u0010~\u0014\u000bH\f";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u000e\u0006\u0010S\u0004-G\u000fG\u001a*G\u0000WI7\t\u0011F\b0\u0004\u0007\u0012\u00068G0a(\u0015\u0002\u001bu\f07\u0003@\b3\u0002\u0016W\u001b\r\u0017\u0007Q";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0013\b\u0006G\u0005+\u0014BA\u0000$\u0002B_\u001c-\u0013BP\f~\n\u0017^\u001d7\u0017\u000eWI1\u0001B\n";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0017\t\u0014S\u00057\u0003BY\f'G\u0012S\u001b?\n\u0007F\f,\u0014";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        b = 2048;
        c = 2048;
    }
}

