/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;

final class RSAPublicKey
extends X509Key
implements java.security.interfaces.RSAPublicKey,
Serializable {
    static final long serialVersionUID = -6195576206650062694L;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private AlgorithmParameterSpec keyParams;
    private static final String[] z;

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.a(this.algid, bigInteger, bigInteger2);
    }

    public RSAPublicKey(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.a(algorithmId, bigInteger, bigInteger2);
    }

    private void a(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
        RSAKeyFactory.b(this.modulus.bitLength(), this.publicExponent);
        this.algid = algorithmId;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            byte[] byArray = derOutputStream.toByteArray();
            this.setKey(new BitArray(byArray.length * 8, byArray));
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[3] + iOException.getMessage());
        }
    }

    public RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        RSAKeyFactory.b(this.modulus.bitLength(), this.publicExponent);
        try {
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)this.algid);
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(providerException);
        }
    }

    public static RSAPublicKey newKey(RSAUtil.KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        AlgorithmId algorithmId = RSAUtil.createAlgorithmId((RSAUtil.KeyType)keyType, (AlgorithmParameterSpec)algorithmParameterSpec);
        return new RSAPublicKey(algorithmId, bigInteger, bigInteger2);
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    public String toString() {
        return z[4] + this.modulus.toString() + z[5] + this.publicExponent.toString() + z[6] + this.keyParams + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.getKey().toByteArray());
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.getTag() != 48) {
                throw new IOException(z[2]);
            }
            DerInputStream derInputStream2 = derValue.getData();
            this.modulus = derInputStream2.getPositiveBigInteger();
            this.publicExponent = derInputStream2.getPositiveBigInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[1]);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[0] + exception.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u001f\u000fRw\u000e?\u0005\u0004}\u0007/ARw\u000e#\u0004\u0004\u001c";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                block17: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block17;
                    n5 = n5;
                    if (n5 <= n4) break block18;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 86;
                            break;
                        }
                        case 1: {
                            n6 = 97;
                            break;
                        }
                        case 2: {
                            n6 = 36;
                            break;
                        }
                        case 3: {
                            n6 = 22;
                            break;
                        }
                        default: {
                            n6 = 98;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0013\u0019Pd\u0003v\u0005Eb\u0003v\u0000Rw\u000b:\u0000Fz\u0007";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0018\u000eP6\u0003v2aG7\u0013/gS";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "5\u000eQz\u0006v\u000fKbB\u0012$v6\u00078\u0002Kr\u0007lA";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u001f#i\\!\u0013AvE#v1Qt\u000e?\u0002\u0004]\u0007/[.{\r2\u0014Hc\u0011lk";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\\\u0011Qt\u000e?\u0002\u0004s\u001a&\u000eJs\f\"[.";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\\\u0011Ed\u0003;\u0012\u001e";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

