/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertificatePolicyId;
import java.io.IOException;

public final class CertificatePolicyMap {
    private CertificatePolicyId issuerDomain;
    private CertificatePolicyId subjectDomain;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificatePolicyMap";

    public CertificatePolicyMap(CertificatePolicyId issuer, CertificatePolicyId subject) {
        if (debug != null) {
            debug.entry(16384L, className, "CertificatePolicyMap", issuer, subject);
            debug.exit(16384L, className, "CertificatePolicyMap");
        }
        this.issuerDomain = issuer;
        this.subjectDomain = subject;
    }

    public CertificatePolicyMap(DerValue val) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificatePolicyMap", val);
        }
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "CertificatePolicyMap", "Invalid encoding for CertificatePolicyMap");
            }
            throw new IOException("Invalid encoding for CertificatePolicyMap");
        }
        this.issuerDomain = new CertificatePolicyId(val.getData().getDerValue());
        this.subjectDomain = new CertificatePolicyId(val.getData().getDerValue());
        if (debug != null) {
            debug.exit(16384L, className, "CertificatePolicyMap");
        }
    }

    public CertificatePolicyId getIssuerIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuerIdentifier");
            debug.exit(16384L, (Object)className, "getIssuerIdentifier", this.issuerDomain);
        }
        return this.issuerDomain;
    }

    public CertificatePolicyId getSubjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectIdentifier");
            debug.exit(16384L, (Object)className, "getSubjectIdentifier", this.subjectDomain);
        }
        return this.subjectDomain;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = "CertificatePolicyMap: [\nIssuerDomain:" + this.issuerDomain.toString() + "SubjectDomain:" + this.subjectDomain.toString() + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        this.issuerDomain.encode(tmp);
        this.subjectDomain.encode(tmp);
        out.write((byte)48, tmp);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }
}

