/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.PKCS12GenDeprecatedKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEWithSHAAnd3KeyTripleDESDeprecatedCipher
extends CipherSpi {
    private Cipher wrappedCipher;
    private static final int DEFAULT_ITERATION_COUNT = 10;
    private static final int DEFAULT_SALT_LENGTH = 20;

    public PBEWithSHAAnd3KeyTripleDESDeprecatedCipher() {
        try {
            this.wrappedCipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate cipher ", exception);
        }
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.wrappedCipher.doFinal(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.wrappedCipher.doFinal(byArray, n, n2, byArray2, n3);
    }

    protected int engineGetBlockSize() {
        return this.wrappedCipher.getBlockSize();
    }

    protected byte[] engineGetIV() {
        return this.wrappedCipher.getIV();
    }

    protected int engineGetOutputSize(int n) {
        return this.wrappedCipher.getOutputSize(n);
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.wrappedCipher.getParameters();
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("AlgorithmParameter not accepted", invalidAlgorithmParameterException);
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        int n2;
        byte[] byArray;
        if (algorithmParameterSpec == null) {
            if (n == 2) {
                throw new InvalidAlgorithmParameterException("params is null");
            }
            byArray = new byte[20];
            secureRandom.nextBytes(byArray);
            n2 = 10;
        } else if (algorithmParameterSpec instanceof PBEParameterSpec) {
            object = (PBEParameterSpec)algorithmParameterSpec;
            byArray = ((PBEParameterSpec)object).getSalt();
            n2 = ((PBEParameterSpec)object).getIterationCount();
        } else {
            throw new InvalidAlgorithmParameterException("incorrect parameter type " + algorithmParameterSpec.getClass());
        }
        if (key == null || !key.getAlgorithm().equals("PBE")) {
            throw new InvalidKeyException("key is null or incorrect type");
        }
        object = key.getEncoded();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray2 = PKCS12GenDeprecatedKey.pfxComputeKeyIVBuffer((byte[])object, byArray, n2, 8, messageDigest);
            byte[] byArray3 = PKCS12GenDeprecatedKey.pfxComputeKeyMaterialBuffer((byte[])object, byArray, n2, 24, messageDigest);
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray3);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            this.wrappedCipher.init(n, (Key)secretKey, ivParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Required algorithm not available ", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException("Invalid key spec " + invalidKeySpecException);
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            if (algorithmParameters == null) {
                this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
            } else {
                this.engineInit(n, key, algorithmParameters.getParameterSpec(PBEParameterSpec.class), secureRandom);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException);
        }
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new UnsupportedOperationException("Cannot set mode of this Cipher");
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new UnsupportedOperationException("Cannot set padding of this Cipher");
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.wrappedCipher.update(byArray, n, n2);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.wrappedCipher.update(byArray, n, n2, byArray2, n3);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey) {
            SecretKey secretKey = (SecretKey)key;
            return secretKey.getEncoded().length * 8;
        }
        return super.engineGetKeySize(key);
    }
}

