/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.FlagsHelper;
import com.ibm.j9ddr.PointerHelper;
import com.ibm.j9ddr.StructureHelper;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import com.ibm.j9ddr.tools.FlagStructureList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class BytecodeGenerator {
    private static void addFlagAlias(Map<String, String> map, String name, String alias) {
        if (map.get(name) == null) {
            map.put(name, alias);
        }
    }

    private static Map<String, String> addFlagAliasesFor(Map<String, String> map, String className) {
        if (className.equals("J9BuildFlags")) {
            BytecodeGenerator.addFlagAlias(map, "arch_arm", "J9VM_ARCH_ARM");
            BytecodeGenerator.addFlagAlias(map, "arch_aarch64", "J9VM_ARCH_AARCH64");
            BytecodeGenerator.addFlagAlias(map, "arch_power", "J9VM_ARCH_POWER");
            BytecodeGenerator.addFlagAlias(map, "arch_riscv", "J9VM_ARCH_RISCV");
            BytecodeGenerator.addFlagAlias(map, "arch_x86", "J9VM_ARCH_X86");
        }
        return map;
    }

    static Map<String, String> getFlagAliasesFor(String className) {
        return BytecodeGenerator.addFlagAliasesFor(new HashMap<String, String>(), className);
    }

    public static Map<String, String> getConstantsAndAliases(StructureReader.StructureDescriptor structure) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (StructureReader.ConstantDescriptor constant : structure.getConstants()) {
            String name = constant.getName();
            map.put(name, null);
        }
        return BytecodeGenerator.addFlagAliasesFor(map, structure.getName());
    }

    public static byte[] getPointerClassBytes(StructureReader reader, StructureTypeManager typeManager, StructureReader.StructureDescriptor structure, String className) {
        if (FlagStructureList.isFlagsStructure(structure.getName())) {
            return FlagsHelper.getClassBytes(structure, className);
        }
        return PointerHelper.getClassBytes(reader, typeManager, structure, className);
    }

    public static byte[] getStructureClassBytes(StructureReader.StructureDescriptor structure, String className) {
        return StructureHelper.getClassBytes(structure, className);
    }
}

