/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.corereaders.ClosingFileReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

public class ARReader {
    private ImageInputStream _backing;
    private long _firstModuleHeader;

    public ARReader(File library) throws IOException {
        this._backing = new ClosingFileReader(library, ByteOrder.BIG_ENDIAN);
        this.initReader();
    }

    private void initReader() throws IOException {
        this._backing.seek(0L);
        byte[] magic = new byte[8];
        this._backing.readFully(magic);
        if (!"<bigaf>\n".equals(new String(magic, "UTF-8"))) {
            throw new IllegalArgumentException();
        }
        this._backing.seek(68L);
        byte[] firstOffset = new byte[20];
        this._backing.readFully(firstOffset);
        this._firstModuleHeader = this._longFromBuffer(firstOffset);
    }

    public ARReader(ImageInputStream in) throws IOException {
        this._backing = in;
        this.initReader();
    }

    public long offsetOfModule(String name) {
        long next = this._firstModuleHeader;
        while (0L != next) {
            try {
                this._backing.seek(next);
                byte[] buffer = new byte[20];
                this._backing.readFully(buffer);
                long length = this._longFromBuffer(buffer);
                this._backing.readFully(buffer);
                long nextOffset = this._longFromBuffer(buffer);
                this._backing.readFully(buffer);
                long prevOffset = this._longFromBuffer(buffer);
                this._backing.seek(next + 108L);
                buffer = new byte[4];
                this._backing.readFully(buffer);
                int nameLen = (int)this._longFromBuffer(buffer);
                buffer = new byte[nameLen];
                this._backing.readFully(buffer);
                String moduleName = null;
                moduleName = 0 < nameLen && 96 == buffer[0] && 10 == buffer[1] ? "" : new String(buffer, 0, nameLen, "UTF-8");
                if (moduleName.equals(name)) {
                    long offset = next + 112L + (long)nameLen;
                    offset = 1L == offset % 2L ? (offset += 3L) : (offset += 2L);
                    return offset;
                }
                next = nextOffset;
            }
            catch (IOException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public long sizeOfModule(String name) {
        long next = this._firstModuleHeader;
        while (0L != next) {
            try {
                this._backing.seek(next);
                byte[] buffer = new byte[20];
                this._backing.readFully(buffer);
                long length = this._longFromBuffer(buffer);
                this._backing.readFully(buffer);
                long nextOffset = this._longFromBuffer(buffer);
                this._backing.readFully(buffer);
                long prevOffset = this._longFromBuffer(buffer);
                this._backing.seek(next + 108L);
                buffer = new byte[4];
                this._backing.readFully(buffer);
                int nameLen = (int)this._longFromBuffer(buffer);
                buffer = new byte[nameLen];
                this._backing.readFully(buffer);
                String moduleName = null;
                moduleName = 0 < nameLen && 96 == buffer[0] && 10 == buffer[1] ? "" : new String(buffer, 0, nameLen, "UTF-8");
                if (moduleName.equals(name)) {
                    return length;
                }
                next = nextOffset;
            }
            catch (IOException e) {
                return -1L;
            }
        }
        return -1L;
    }

    private long _longFromBuffer(byte[] buffer) {
        long length;
        int total = buffer.length;
        while (32 == buffer[total - 1]) {
            --total;
        }
        try {
            length = Long.parseLong(new String(buffer, 0, total, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return 0L;
        }
        return length;
    }

    public void close() throws IOException {
        if (this._backing != null) {
            this._backing.close();
        }
    }
}

