/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.le;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeedsaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeedsahpTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp_transition32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp_transition64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceedsahp_transitionTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Ceexdsaf {
    private static final long Ceedsahp_UpToDown = 2L;
    private static final long Ceedsahp_DownToUp = 3L;
    long DSA_Prev;
    int DSA_Format;
    private AddressSpaceImageInputStream inputStream;
    private boolean is64bit;
    private static final boolean lenient = true;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    Ceexdsaf(AddressSpace space, long DSA_In, int dsa_fmt, boolean is64bit) throws IOException {
        block17: {
            log.fine("enter Ceexdsaf for dsa " + Ceexdsaf.hex(DSA_In));
            CeedsahpTemplate ceedsahpTemplate = null;
            Ceedsahp_transitionTemplate ceedsahp_transitionTemplate = null;
            if (is64bit) {
                ceedsahpTemplate = new Ceedsahp64Template();
                ceedsahp_transitionTemplate = new Ceedsahp_transition64Template();
            } else {
                ceedsahpTemplate = new Ceedsahp32Template();
                ceedsahp_transitionTemplate = new Ceedsahp_transition32Template();
            }
            this.inputStream = space.getImageInputStream();
            this.DSA_Format = dsa_fmt;
            try {
                if (this.DSA_Format == 0) {
                    long ceedsabkc = CeedsaTemplate.getCeedsabkc(this.inputStream, DSA_In);
                    if (ceedsabkc == 0xFFFFFFFFL) {
                        boolean isTransitional = true;
                        long ceedsatran = CeedsaTemplate.getCeedsatran(this.inputStream, DSA_In);
                        long ceedsahp_trtype = ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, ceedsatran);
                        if (ceedsahp_trtype == 3L) {
                            this.DSA_Prev = ceedsahp_transitionTemplate.getCeedsahp_bkc(this.inputStream, ceedsatran);
                            this.DSA_Format = 1;
                        } else {
                            this.DSA_Prev = ceedsabkc;
                        }
                    } else {
                        this.DSA_Prev = ceedsabkc;
                    }
                    break block17;
                }
                long ceedsahpr7 = ceedsahpTemplate.getCeedsahpr7(this.inputStream, DSA_In);
                log.fine("ceedsahpr7 = " + Ceexdsaf.hex(ceedsahpr7));
                if (!is64bit) {
                    ceedsahpr7 &= Integer.MAX_VALUE;
                }
                if (ceedsahpr7 == 0L) {
                    long ceedsahptran = ceedsahpTemplate.getCeedsahptran(this.inputStream, DSA_In);
                    log.fine("ceedsahptran = " + Ceexdsaf.hex(ceedsahptran));
                    long ceedsahp_trtype = ceedsahp_transitionTemplate.getCeedsahp_trtype(this.inputStream, ceedsahptran);
                    log.fine("ceedsahp_trtype = " + Ceexdsaf.hex(ceedsahp_trtype));
                    if (ceedsahp_trtype == 2L) {
                        this.DSA_Format = 0;
                    }
                    boolean isTransitional = true;
                    this.DSA_Prev = ceedsahp_transitionTemplate.getCeedsahp_bkc(this.inputStream, ceedsahptran);
                    log.fine("DSA_Prev = " + Ceexdsaf.hex(this.DSA_Prev));
                    break block17;
                }
                try {
                    long Entry_Temp = DsaStackFrame.hpclEntryPoint(space, DSA_In, ceedsahpr7, ceedsahpTemplate);
                    log.fine("Entry_Temp = " + Ceexdsaf.hex(Entry_Temp));
                    if (Entry_Temp == 0L) {
                        this.DSA_Prev = 0L;
                        break block17;
                    }
                    int dsaFlags = space.readInt(Entry_Temp - 4L);
                    if ((dsaFlags & 4) == 4) {
                        this.DSA_Prev = ceedsahpTemplate.getCeedsahpr4(this.inputStream, DSA_In);
                        break block17;
                    }
                    int dsaSize = dsaFlags & 0xFFFFFFF0;
                    this.DSA_Prev = DSA_In + (long)dsaSize;
                }
                catch (IOException e) {
                    log.finer("caught exception: " + e);
                    this.DSA_Prev = ceedsahpTemplate.getCeedsahpr4(this.inputStream, DSA_In);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexdsaf", "Ceexdsaf", "Unexpected Exception", e);
                throw new Error("Unexpected Exception: " + e);
            }
        }
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }
}

