/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import java.util.HashMap;
import java.util.Map;

public class StructureCommandUtil {
    public static Context cachedContext;
    public static Map<String, StructureReader.StructureDescriptor> structureMap;
    public static StructureTypeManager typeManager;
    private static String pointerFormatString;

    public static Map<String, StructureReader.StructureDescriptor> getStructureMap(Context context) {
        StructureCommandUtil.checkContextCache(context);
        return structureMap;
    }

    public static StructureReader.StructureDescriptor getStructureDescriptor(String command, Context context) {
        StructureCommandUtil.checkContextCache(context);
        return structureMap.get(command.toLowerCase());
    }

    public static int getTypeCode(String type2, Context context) {
        StructureCommandUtil.checkContextCache(context);
        return typeManager.getType(type2);
    }

    public static String typeToCommand(String type2) {
        type2 = type2.replace("struct", "");
        type2 = type2.replace("class", "");
        type2 = type2.replace("*", "");
        type2 = type2.trim();
        return "!" + type2.toLowerCase();
    }

    private static void checkContextCache(Context context) {
        if (context != cachedContext) {
            cachedContext = context;
            StructureCommandUtil.loadStructureMap();
        }
    }

    private static void loadStructureMap() {
        structureMap = new HashMap<String, StructureReader.StructureDescriptor>();
        for (StructureReader.StructureDescriptor descriptor : StructureCommandUtil.cachedContext.vmData.getStructures()) {
            structureMap.put(descriptor.getName().toLowerCase(), descriptor);
        }
        typeManager = new StructureTypeManager(StructureCommandUtil.cachedContext.vmData.getStructures());
        StringBuilder b = new StringBuilder();
        b.append("0x%0");
        b.append(2 * StructureCommandUtil.cachedContext.process.bytesPerPointer());
        b.append("X");
        pointerFormatString = b.toString();
    }

    public static String formatPointer(long address, Context context) {
        StructureCommandUtil.checkContextCache(context);
        return String.format(pointerFormatString, address);
    }
}

