/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.command.CommandParser;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.text.ParseException;

public class TimeCommand
extends Command {
    public TimeCommand() {
        this.addCommand("time", "<command>", "run another command and print out elapsed time");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        String[] newArgs = null;
        if (args.length < 1) {
            out.println("The time command requires another command to run as an argument.");
            return;
        }
        if (args.length > 1) {
            newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        } else {
            newArgs = new String[]{};
        }
        try {
            CommandParser commandParser = new CommandParser(args[0], newArgs);
            long startTime = System.currentTimeMillis();
            context.execute(commandParser, out);
            long endTime = System.currentTimeMillis();
            double secs = ((double)endTime - (double)startTime) / 1000.0;
            out.printf("\n---\nCommand '%s' took %f seconds\n", commandParser.toString(), secs);
        }
        catch (ParseException e) {
            e.printStackTrace(out);
        }
    }
}

