/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.j9.SignalName;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.JavaVMOption;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.VMDataFactory;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.EnvironmentUtils;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRBaseImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageModule;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9DDRStubImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9RASImageDataFactory;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class J9DDRImageProcess
implements ImageProcess {
    private static final String JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE = "OPENJ9_JAVA_COMMAND_LINE";
    private static final String LEGACY_JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE = "IBM_JAVA_COMMAND_LINE";
    private final IProcess process;
    private boolean processDataSet;
    private J9RASImageDataFactory.ProcessData j9rasProcessData;
    private String version;
    private WeakReference<Map<Long, Object>> cachedThreads;

    public J9DDRImageProcess(IProcess thisProcess) {
        this.process = thisProcess;
    }

    public IProcess getIProcess() {
        return this.process;
    }

    public String getCommandLine() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            Properties environment = this.getEnvironment();
            String javaCommandLine = environment.getProperty(JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE);
            if (javaCommandLine != null) {
                return javaCommandLine;
            }
            javaCommandLine = environment.getProperty(LEGACY_JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE);
            if (javaCommandLine != null) {
                return javaCommandLine;
            }
            return this.process.getCommandLine();
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(this.process, e);
        }
        catch (DataUnavailableException e) {
            throw new DataUnavailable(e.getMessage());
        }
    }

    private void checkFailureInfo() {
        if (!this.processDataSet) {
            this.j9rasProcessData = J9RASImageDataFactory.getProcessData(this.process);
            this.processDataSet = true;
        }
    }

    public ImageThread getCurrentThread() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                long currentThreadId;
                try {
                    currentThreadId = this.j9rasProcessData.tid();
                }
                catch (DataUnavailable e) {
                    Iterator<? extends IOSThread> iterator = this.process.getThreads().iterator();
                    if (iterator.hasNext()) {
                        IOSThread thread = iterator.next();
                        return new J9DDRImageThread(this.process, thread);
                    }
                    return null;
                }
                for (IOSThread iOSThread : this.process.getThreads()) {
                    if (iOSThread.getThreadId() != currentThreadId) continue;
                    return new J9DDRImageThread(this.process, iOSThread);
                }
                if (currentThreadId == 0L && this.process.getPlatform() == Platform.ZOS) {
                    for (IOSThread iOSThread : this.process.getThreads()) {
                        Properties threadProps = iOSThread.getProperties();
                        String tcc = threadProps.getProperty("Task Completion Code");
                        if (tcc == null || tcc.equals("0x0")) continue;
                        return new J9DDRImageThread(this.process, iOSThread);
                    }
                }
                return new J9DDRStubImageThread(this.process, currentThreadId);
            }
            return null;
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(this.process, e);
        }
    }

    public Properties getEnvironment() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                try {
                    Properties properties;
                    long environ = this.j9rasProcessData.getEnvironment();
                    if (this.process.getPlatform() == Platform.WINDOWS && this.j9rasProcessData.version() > 4) {
                        properties = EnvironmentUtils.readEnvironmentStrings(this.process, environ);
                    } else {
                        long stringPointer = this.process.getPointerAt(environ);
                        properties = EnvironmentUtils.readEnvironment(this.process, stringPointer);
                    }
                    if (null == properties || 0 == properties.size()) {
                        throw new CorruptDataException("");
                    }
                    return properties;
                }
                catch (CorruptDataException e1) {
                    return this.process.getEnvironmentVariables();
                }
            }
            return this.process.getEnvironmentVariables();
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(this.process, e);
        }
        catch (DataUnavailableException e) {
            throw new DataUnavailable(e.getMessage());
        }
    }

    public ImageModule getExecutable() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        IModule executable;
        try {
            executable = this.process.getExecutable();
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(new J9DDRCorruptData(this.process, e));
        }
        if (executable == null) {
            throw new DataUnavailable("executable not found");
        }
        if (this.process.getPlatform() == Platform.LINUX) {
            String executableName = this.getExecutablePath();
            if (null == executableName) {
                return new J9DDRImageModule(this.process, executable);
            }
            return new J9DDRImageModule(this.process, executable, executableName);
        }
        return new J9DDRImageModule(this.process, executable);
    }

    String getExecutablePath() {
        String commandLine;
        try {
            commandLine = this.getCommandLine();
        }
        catch (Exception e) {
            return this.getExecutablePathFromSystemProperties();
        }
        int spaceIndex = commandLine.indexOf(" ");
        String executableName = spaceIndex != -1 ? commandLine.substring(0, spaceIndex) : commandLine;
        return executableName;
    }

    private String getExecutablePathFromSystemProperties() {
        Iterator<?> runtimeIt = this.getRuntimes();
        while (runtimeIt.hasNext()) {
            Object o = runtimeIt.next();
            if (!(o instanceof JavaRuntime)) continue;
            JavaRuntime runtime = (JavaRuntime)o;
            try {
                JavaVMInitArgs args = runtime.getJavaVMInitArgs();
                Iterator optionsIt = args.getOptions();
                Pattern javaHomePattern = Pattern.compile("-Djava.home=(.*)");
                while (optionsIt.hasNext()) {
                    JavaVMOption option;
                    Matcher m;
                    Object optionObj = optionsIt.next();
                    if (!(optionObj instanceof JavaVMOption) || !(m = javaHomePattern.matcher((option = (JavaVMOption)optionObj).getOptionString())).find()) continue;
                    String javaHome = m.group(1);
                    return javaHome + "/bin/java";
                }
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public String getID() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                try {
                    return Long.toString(this.j9rasProcessData.pid());
                }
                catch (DataUnavailable e) {
                    return Long.toString(this.process.getProcessId());
                }
            }
            return Long.toString(this.process.getProcessId());
        }
        catch (CorruptDataException e) {
            return "<Unknown>";
        }
    }

    public String toString() {
        try {
            return "ImageProcess: " + this.getID();
        }
        catch (Exception ex) {
            return "ImageProcess";
        }
    }

    public Iterator<?> getLibraries() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            Collection<? extends IModule> modules = this.process.getModules();
            ArrayList<J9DDRImageModule> libraries = new ArrayList<J9DDRImageModule>();
            for (IModule iModule : modules) {
                libraries.add(new J9DDRImageModule(this.process, iModule));
            }
            return libraries.iterator();
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(new J9DDRCorruptData(this.process, e));
        }
    }

    public int getPointerSize() {
        return this.process.bytesPerPointer() * 8;
    }

    public Iterator<?> getRuntimes() {
        LinkedList<Object> toIterate = new LinkedList<Object>();
        try {
            IVMData data = VMDataFactory.getVMData(this.process);
            this.version = data.getVersion();
            Object[] passbackArray = new Object[1];
            try {
                data.bootstrapRelative("view.dtfj.DTFJBootstrapShim", passbackArray, this);
            }
            catch (ClassNotFoundException e) {
                try {
                    data.bootstrap("com.ibm.j9ddr.view.nativert.Bootstrap", passbackArray, this);
                }
                catch (ClassNotFoundException e1) {
                    throw new Error(e1);
                }
            }
            if (passbackArray[0] != null) {
                toIterate.add(passbackArray[0]);
            }
        }
        catch (IOException e) {
            toIterate.add(new J9DDRCorruptData(this.process, "Unsupported JVM level: " + e.getMessage()));
        }
        catch (UnsupportedOperationException e) {
            toIterate.add(new J9DDRCorruptData(this.process, "Unsupported JVM level"));
        }
        catch (Exception e) {
            toIterate.add(new J9DDRCorruptData(this.process, e.getMessage()));
        }
        return toIterate.iterator();
    }

    public String getSignalName() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        String name = null;
        int signal = this.getSignalNumber();
        if (signal != 0) {
            switch (this.process.getPlatform()) {
                case AIX: {
                    name = SignalName.forAIX((int)signal);
                    break;
                }
                case LINUX: {
                    name = SignalName.forLinux((int)signal);
                    break;
                }
                case OSX: {
                    name = SignalName.forOSX((int)signal);
                    break;
                }
                case WINDOWS: {
                    name = SignalName.forWindows((int)signal);
                    break;
                }
                case ZOS: {
                    name = SignalName.forZOS((int)signal);
                    break;
                }
            }
            if (name == null) {
                name = "Unknown signal number " + signal;
            }
        }
        return name;
    }

    public int getSignalNumber() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        this.checkFailureInfo();
        try {
            String gpInfo = this.j9rasProcessData.gpInfo();
            if (gpInfo != null) {
                String[] keys;
                switch (this.process.getPlatform()) {
                    case AIX: 
                    case LINUX: 
                    case OSX: {
                        keys = new String[]{"Signal_Number"};
                        break;
                    }
                    case WINDOWS: {
                        keys = new String[]{"Windows_ExceptionCode", "ExceptionCode"};
                        break;
                    }
                    case ZOS: {
                        keys = new String[]{"Signal_Number", "Condition_Message_Number"};
                        break;
                    }
                    default: {
                        keys = new String[]{};
                    }
                }
                for (String key : keys) {
                    int signal = (int)J9DDRImageProcess.longByResolvingRawKey(gpInfo, key);
                    if (signal == 0) continue;
                    return signal;
                }
            }
        }
        catch (CorruptDataException gpInfo) {
            // empty catch block
        }
        try {
            return this.process.getSignalNumber();
        }
        catch (DataUnavailableException e) {
            return 0;
        }
    }

    private Map<Long, Object> getThreadMap() {
        HashMap<Long, Object> dtfjThreadMap = null;
        if (this.cachedThreads != null) {
            dtfjThreadMap = (HashMap<Long, Object>)this.cachedThreads.get();
        }
        if (dtfjThreadMap == null) {
            Collection<? extends IOSThread> threads;
            long corruptId = -1L;
            try {
                threads = this.process.getThreads();
            }
            catch (CorruptDataException e) {
                return Collections.singletonMap(corruptId, new J9DDRCorruptData(this.process, e));
            }
            boolean forkandabort = this.process.getPlatform() == Platform.LINUX && threads.size() == 1;
            dtfjThreadMap = new HashMap<Long, Object>();
            if (forkandabort) {
                try {
                    J9DDRBaseImageThread currentThread = (J9DDRBaseImageThread)this.getCurrentThread();
                    if (currentThread != null) {
                        dtfjThreadMap.put(currentThread.getThreadId(), currentThread);
                    }
                }
                catch (com.ibm.dtfj.image.CorruptDataException e) {
                    dtfjThreadMap.put(corruptId--, new J9DDRCorruptData(this.process, e.getMessage()));
                }
                catch (CorruptDataException e) {
                    dtfjThreadMap.put(corruptId--, new J9DDRCorruptData(this.process, e.getMessage()));
                }
            }
            for (IOSThread iOSThread : threads) {
                try {
                    dtfjThreadMap.put(iOSThread.getThreadId(), new J9DDRImageThread(this.process, iOSThread));
                }
                catch (CorruptDataException e) {
                    dtfjThreadMap.put(corruptId--, new J9DDRImageThread(this.process, iOSThread));
                }
            }
            this.cachedThreads = new WeakReference(dtfjThreadMap);
        }
        return dtfjThreadMap;
    }

    public Iterator<?> getThreads() {
        Map<Long, Object> dtfjThreadMap = this.getThreadMap();
        return dtfjThreadMap.values().iterator();
    }

    public J9DDRBaseImageThread getThread(long id) {
        Map<Long, Object> dtfjThreadMap = this.getThreadMap();
        return (J9DDRBaseImageThread)dtfjThreadMap.get(id);
    }

    private static long longByResolvingRawKey(String rawText, String key) {
        Pattern pattern = Pattern.compile("\\b" + Pattern.quote(key) + "=(\\p{XDigit}+)");
        Matcher matcher = pattern.matcher(rawText);
        if (matcher.find()) {
            return Long.parseUnsignedLong(matcher.group(1), 16);
        }
        return 0L;
    }

    public String getVersion() {
        return this.version;
    }

    boolean isFailingProcess() throws DataUnavailableException {
        return this.process.isFailingProcess();
    }

    public Properties getProperties() {
        return new Properties();
    }
}

