/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.Pointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.UDATA;

public class ObjectMonitorReferencePointer
extends Pointer {
    public static final ObjectMonitorReferencePointer NULL = new ObjectMonitorReferencePointer(0L);
    public static final long SIZEOF = J9BuildFlags.interp_smallMonitorSlot ? 4L : (long)UDATA.SIZEOF;

    protected ObjectMonitorReferencePointer(long address) {
        super(address);
    }

    public static ObjectMonitorReferencePointer cast(AbstractPointer pointer) {
        return ObjectMonitorReferencePointer.cast(pointer.getAddress());
    }

    public static ObjectMonitorReferencePointer cast(UDATA udata) {
        return ObjectMonitorReferencePointer.cast(udata.longValue());
    }

    public static ObjectMonitorReferencePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ObjectMonitorReferencePointer(address);
    }

    @Override
    public ObjectMonitorReferencePointer add(long count) {
        return new ObjectMonitorReferencePointer(this.address + SIZEOF * count);
    }

    @Override
    public ObjectMonitorReferencePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public ObjectMonitorReferencePointer addOffset(long offset) {
        return new ObjectMonitorReferencePointer(this.address + offset);
    }

    @Override
    public ObjectMonitorReferencePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9ObjectMonitorPointer at(long index) throws CorruptDataException {
        return this.getObjectMonitorAtOffset(index * SIZEOF);
    }

    @Override
    public J9ObjectMonitorPointer at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return SIZEOF;
    }

    @Override
    public ObjectMonitorReferencePointer sub(long count) {
        return new ObjectMonitorReferencePointer(this.address - SIZEOF * count);
    }

    @Override
    public ObjectMonitorReferencePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public ObjectMonitorReferencePointer subOffset(long offset) {
        return new ObjectMonitorReferencePointer(this.address - offset);
    }

    @Override
    public ObjectMonitorReferencePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public ObjectMonitorReferencePointer untag(long tagBits) {
        return new ObjectMonitorReferencePointer(this.address & (tagBits ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ObjectMonitorReferencePointer untag() {
        return this.untag(SIZEOF - 1L);
    }
}

