/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm26.j9.HashTable;
import com.ibm.j9ddr.vm26.j9.IHashTable;
import com.ibm.j9ddr.vm26.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm26.j9.SlotIterator;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.HashMap;
import java.util.Iterator;

public class MonitorTable
implements IHashTable<J9ObjectMonitorPointer> {
    protected HashTable<PointerPointer> monitorTable;
    protected HashMap<J9ObjectPointer, J9ObjectMonitorPointer> cachedMonitorTable;
    protected J9HashTablePointer hashTable;

    protected MonitorTable(J9HashTablePointer hashTable) throws CorruptDataException {
        HashTable.HashEqualFunction<PointerPointer> equalFunction = MonitorTable.getEqualFunction();
        HashTable.HashFunction<PointerPointer> hashFunction = MonitorTable.getHashFunction();
        this.hashTable = hashTable;
        this.monitorTable = HashTable.fromJ9HashTable(hashTable, PointerPointer.class, equalFunction, hashFunction);
    }

    public static MonitorTable from(J9HashTablePointer table) throws CorruptDataException {
        return new MonitorTable(table);
    }

    private static HashTable.HashFunction<PointerPointer> getHashFunction() {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_MONITOR_HASH_FUNCTION_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new MonitorHashFunction_V1();
    }

    private static HashTable.HashEqualFunction<PointerPointer> getEqualFunction() {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_MONITOR_EQUAL_FUNCTION_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new MonitorEqualFunction_V1();
    }

    @Override
    public SlotIterator<J9ObjectMonitorPointer> iterator() {
        return new SlotIterator<J9ObjectMonitorPointer>(){
            SlotIterator<PointerPointer> monitorTableIterator;
            {
                this.monitorTableIterator = MonitorTable.this.monitorTable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.monitorTableIterator.hasNext();
            }

            @Override
            public J9ObjectMonitorPointer next() {
                return J9ObjectMonitorPointer.cast((AbstractPointer)this.monitorTableIterator.next());
            }

            @Override
            public VoidPointer nextAddress() {
                return this.monitorTableIterator.nextAddress();
            }

            @Override
            public void remove() {
                this.monitorTableIterator.remove();
            }
        };
    }

    @Override
    public long getCount() {
        return this.monitorTable.getCount();
    }

    @Override
    public String getTableName() {
        return this.monitorTable.getTableName();
    }

    public J9ObjectMonitorPointer peek(J9ObjectPointer object) {
        if (this.cachedMonitorTable == null) {
            this.initializedCachedMonitorTable();
        }
        return this.cachedMonitorTable.get(object);
    }

    private void initializedCachedMonitorTable() {
        this.cachedMonitorTable = new HashMap();
        try {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                J9ObjectMonitorPointer objectMonitor = (J9ObjectMonitorPointer)iterator.next();
                J9ObjectPointer object = J9ObjectPointer.cast(objectMonitor.monitor().userData());
                this.cachedMonitorTable.put(object, objectMonitor);
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error building cached monitor table", e, false);
        }
    }

    public J9HashTablePointer getJ9HashTablePointer() {
        return this.hashTable;
    }

    protected static class MonitorEqualFunction_V1
    implements HashTable.HashEqualFunction<PointerPointer> {
        protected MonitorEqualFunction_V1() {
        }

        @Override
        public boolean equal(PointerPointer entry1, PointerPointer entry2) {
            try {
                J9ObjectMonitorPointer leftKey = J9ObjectMonitorPointer.cast(entry1);
                J9ObjectMonitorPointer rightKey = J9ObjectMonitorPointer.cast(entry2);
                J9ThreadAbstractMonitorPointer leftMonitor = J9ThreadAbstractMonitorPointer.cast(leftKey.monitor());
                J9ThreadAbstractMonitorPointer rightMonitor = J9ThreadAbstractMonitorPointer.cast(rightKey.monitor());
                return leftMonitor.userData().eq(rightMonitor.userData());
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error checking equality", e, true);
                return false;
            }
        }
    }

    protected static class MonitorHashFunction_V1
    implements HashTable.HashFunction<PointerPointer> {
        protected MonitorHashFunction_V1() {
        }

        @Override
        public UDATA hash(PointerPointer entry) {
            try {
                J9ObjectMonitorPointer key = J9ObjectMonitorPointer.cast(entry);
                J9ThreadAbstractMonitorPointer monitor = J9ThreadAbstractMonitorPointer.cast(key.monitor());
                J9ObjectPointer object = J9ObjectPointer.cast(monitor.userData());
                return new UDATA(ObjectAccessBarrier.getObjectHashCode(object));
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error calculating hash", e, false);
                return new UDATA(0L);
            }
            catch (DataUnavailableException e) {
                EventManager.raiseCorruptDataEvent("Hashcode not available", new CorruptDataException(e), false);
                return new UDATA(0L);
            }
        }
    }
}

