/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm26.j9.ObjectModel;
import com.ibm.j9ddr.vm26.j9.gc.GCEmptyObjectIterator_V1;
import com.ibm.j9ddr.vm26.j9.gc.GCIterator;
import com.ibm.j9ddr.vm26.j9.gc.GCMixedObjectIterator_V1;
import com.ibm.j9ddr.vm26.j9.gc.GCPointerArrayIterator_V1;
import com.ibm.j9ddr.vm26.j9.gc.GCPointerArrayletIterator_V1;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.structure.J9Object;

public abstract class GCObjectIterator
extends GCIterator {
    protected J9ObjectPointer object;
    protected boolean includeClassSlot;

    protected GCObjectIterator(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        this.object = object;
        this.includeClassSlot = includeClassSlot;
    }

    public static GCObjectIterator fromJ9Object(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        if (ObjectModel.isIndexable(object)) {
            if (ObjectModel.getClassShape(object).eq(J9Object.OBJECT_HEADER_SHAPE_POINTERS)) {
                return GCObjectIterator.getPointerArrayImpl(object, includeClassSlot);
            }
            return GCObjectIterator.getEmptyObjectIteratorImpl(object, includeClassSlot);
        }
        return GCObjectIterator.getMixedObjectIteratorImpl(object, includeClassSlot);
    }

    @Override
    public abstract J9ObjectPointer next();

    private static GCObjectIterator getPointerArrayImpl(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        if (J9BuildFlags.gc_arraylets) {
            AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_POINTER_ARRAYLET_ITERATOR_VERSION");
            switch (version.getAlgorithmVersion()) {
                default: 
            }
            return new GCPointerArrayletIterator_V1(object, includeClassSlot);
        }
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_POINTER_ARRAY_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCPointerArrayIterator_V1(object, includeClassSlot);
    }

    private static GCObjectIterator getEmptyObjectIteratorImpl(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_EMPTY_OBJECT_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCEmptyObjectIterator_V1(object, includeClassSlot);
    }

    private static GCObjectIterator getMixedObjectIteratorImpl(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_MIXED_OBJECT_ITERATOR_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCMixedObjectIterator_V1(object, includeClassSlot);
    }
}

