/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.gc.GCBase;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm27.types.UDATA;

public class GCExtensions {
    private static MM_GCExtensionsPointer gcExtensions;
    private static boolean isMetronomeGC;
    private static boolean isStandardGC;
    private static boolean isVLHGC;
    private static boolean isMultiTenantGC;
    private static boolean scavengerEnabled;
    private static UDATA softMx;

    public static boolean isMetronomeGC() {
        return isMetronomeGC;
    }

    public static boolean isStandardGC() {
        return isStandardGC;
    }

    public static boolean isVLHGC() {
        return isVLHGC;
    }

    public static boolean isMultiTenantGC() {
        return isMultiTenantGC;
    }

    public static boolean scavengerEnabled() {
        return scavengerEnabled;
    }

    public static UDATA softMx() {
        return softMx;
    }

    public static MM_GCExtensionsPointer getGCExtensionsPointer() {
        return gcExtensions;
    }

    static {
        try {
            gcExtensions = GCBase.getExtensions();
            isMultiTenantGC = false;
            if (J9BuildFlags.gc_combinationSpec) {
                isMetronomeGC = gcExtensions._isMetronomeGC();
                isStandardGC = gcExtensions._isStandardGC();
                isVLHGC = gcExtensions._isVLHGC();
                if (J9BuildFlags.opt_tenant) {
                    isMultiTenantGC = gcExtensions._isMultiTenantGC();
                }
            } else {
                isMetronomeGC = J9BuildFlags.gc_realtime;
                isStandardGC = J9BuildFlags.gc_modronStandard;
                isVLHGC = J9BuildFlags.gc_vlhgc;
            }
            scavengerEnabled = J9BuildFlags.gc_modronScavenger || J9BuildFlags.gc_vlhgc ? gcExtensions.scavengerEnabled() : false;
            softMx = gcExtensions.softMx();
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error initializing GCExtensions", cde, true);
            gcExtensions = null;
        }
    }
}

