/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.gc.GCArrayObjectModel;
import com.ibm.j9ddr.vm27.j9.gc.GCBase;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm27.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm27.types.UDATA;

public class GCPackedArrayletIterator_V1
extends GCObjectIterator {
    private GCArrayObjectModel _packedArrayObjectModel;
    private GCObjectIterator _packedObjectIterator;
    private J9ClassPointer _componentClazz;
    private VoidPointer _currentArrayletBaseAddress;
    private UDATA _packedDataSize;
    private UDATA _arrayletLeafSize;
    private UDATA _numberOfElementsPerLeaf;
    private boolean _targetReturned;
    private int _index;
    private UDATA _currentArrayletOffset;
    private VoidPointer _nextAddr;

    protected GCPackedArrayletIterator_V1(J9ObjectPointer object, boolean includeClassSlot, boolean includeTargetObject) throws CorruptDataException {
        super(object, includeClassSlot);
        J9IndexableObjectPointer array = J9IndexableObjectPointer.cast(object);
        this._packedArrayObjectModel = GCArrayObjectModel.from(true);
        this._packedDataSize = this._packedArrayObjectModel.getPackedDataSize(array);
        this._componentClazz = J9IndexableObjectHelper.clazz(array).componentType();
        this._arrayletLeafSize = GCBase.getJavaVM().arrayletLeafSize();
        this._numberOfElementsPerLeaf = this._arrayletLeafSize.div(this._packedDataSize);
        this._index = this._packedArrayObjectModel.getSizeInElements(array).intValue();
        this._targetReturned = !includeTargetObject;
        this.recalculateArrayletOffsets();
        this._nextAddr = this.nextAddrImpl();
    }

    private void recalculateArrayletOffsets() throws CorruptDataException {
        if (this._index > 0) {
            UDATA leafWithElement = new UDATA(this._index - 1).div(this._numberOfElementsPerLeaf);
            this._currentArrayletOffset = new UDATA(this._index - 1).mod(this._numberOfElementsPerLeaf);
            ObjectReferencePointer arrayoidPointer = this._packedArrayObjectModel.getArrayoidPointer(J9IndexableObjectPointer.cast(this.object));
            this._currentArrayletBaseAddress = VoidPointer.cast(arrayoidPointer.at(leafWithElement));
            if (this._currentArrayletBaseAddress.isNull()) {
                this.object = null;
                this._index = 0;
            } else {
                VoidPointer data = this._currentArrayletBaseAddress.addOffset(this._currentArrayletOffset.mult(this._packedDataSize));
                this._packedObjectIterator = GCObjectIterator.fromJ9Class(this._componentClazz, data);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this._nextAddr != null;
    }

    @Override
    public J9ObjectPointer next() {
        J9ObjectPointer result = null;
        try {
            VoidPointer nextAddress = this.nextAddress();
            result = ObjectReferencePointer.cast(nextAddress).at(0L);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
        }
        return result;
    }

    @Override
    public VoidPointer nextAddress() {
        VoidPointer result = this._nextAddr;
        this._nextAddr = this.nextAddrImpl();
        return result;
    }

    private VoidPointer nextAddrImpl() {
        try {
            if (this.object != null) {
                if (!this._targetReturned) {
                    this._targetReturned = true;
                    return VoidPointer.cast(this._packedArrayObjectModel.getTargetObjectEA(J9IndexableObjectPointer.cast(this.object)));
                }
                if (this.includeClassSlot) {
                    this.includeClassSlot = false;
                    return VoidPointer.cast(J9ObjectHelper.clazz(this.object).classObjectEA());
                }
                while (this._index > 0) {
                    if (this._packedObjectIterator.hasNext()) {
                        return this._packedObjectIterator.nextAddress();
                    }
                    --this._index;
                    if (this._currentArrayletOffset.eq(0L)) {
                        this.recalculateArrayletOffsets();
                        continue;
                    }
                    this._currentArrayletOffset = this._currentArrayletOffset.sub(1L);
                    VoidPointer data = this._currentArrayletBaseAddress.addOffset(this._currentArrayletOffset.mult(this._packedDataSize));
                    this._packedObjectIterator = GCObjectIterator.fromJ9Class(this._componentClazz, data);
                }
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
        return null;
    }
}

