/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.Pointer;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

public class UDATAPointer
extends Pointer {
    public static final int SIZEOF = UDATA.SIZEOF;
    public static final UDATAPointer NULL = new UDATAPointer(0L);

    protected UDATAPointer(long address) {
        super(address);
    }

    public static UDATAPointer cast(AbstractPointer pointer) {
        return UDATAPointer.cast(pointer.getAddress());
    }

    public static UDATAPointer cast(UDATA udata) {
        return UDATAPointer.cast(udata.longValue());
    }

    public static UDATAPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new UDATAPointer(address);
    }

    @Override
    public UDATA at(long index) throws CorruptDataException {
        return this.getUDATAAtOffset((long)SIZEOF * index);
    }

    @Override
    public UDATA at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    public UDATAPointer untag() {
        return this.untag(SIZEOF - 1);
    }

    @Override
    public UDATAPointer untag(long mask) {
        return new UDATAPointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public UDATAPointer add(long count) {
        return new UDATAPointer(this.address + (long)SIZEOF * count);
    }

    @Override
    public UDATAPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public UDATAPointer addOffset(long offset) {
        return new UDATAPointer(this.address + offset);
    }

    @Override
    public UDATAPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public UDATAPointer sub(long count) {
        return new UDATAPointer(this.address - (long)SIZEOF * count);
    }

    @Override
    public UDATAPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public UDATAPointer subOffset(long offset) {
        return new UDATAPointer(this.address - offset);
    }

    @Override
    public UDATAPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return SIZEOF;
    }
}

