/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.HashTable;
import com.ibm.j9ddr.vm28.j9.SlotIterator;
import com.ibm.j9ddr.vm28.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm28.pointer.AbstractPointer;
import com.ibm.j9ddr.vm28.pointer.PointerPointer;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm28.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm28.pointer.generated.MM_StringTablePointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm28.structure.MM_StringTable;
import com.ibm.j9ddr.vm28.types.U32;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.util.NoSuchElementException;

public class StringTable {
    protected MM_StringTablePointer _stringTable;
    protected long _tableCount;
    StringHashFunction<PointerPointer> _hashFn;

    protected StringTable(MM_StringTablePointer stringTable) throws CorruptDataException {
        this._stringTable = stringTable;
        this._tableCount = stringTable._tableCount().longValue();
        this._hashFn = new StringHashFunction();
    }

    public static StringTable from() throws CorruptDataException {
        MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
        return new StringTable(extensions.stringTable());
    }

    public SlotIterator<J9ObjectPointer> iterator() {
        return new SlotIterator<J9ObjectPointer>(){
            private SlotIterator<PointerPointer> hashTableIterator = null;
            private long currentIndex = 0L;

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.hashTableIterator != null) {
                        if (this.hashTableIterator.hasNext()) {
                            return true;
                        }
                        ++this.currentIndex;
                    }
                    if (this.currentIndex >= StringTable.this._tableCount) {
                        this.hashTableIterator = null;
                        return false;
                    }
                    try {
                        J9HashTablePointer hashTable = J9HashTablePointer.cast(StringTable.this._stringTable._table().at(this.currentIndex));
                        HashTable<PointerPointer> currentHashTable = HashTable.fromJ9HashTable(hashTable, false, PointerPointer.class, StringTable.this._hashFn, new StringComparatorFunction());
                        this.hashTableIterator = currentHashTable.iterator();
                        continue;
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public J9ObjectPointer next() {
                if (this.hasNext()) {
                    PointerPointer next = (PointerPointer)this.hashTableIterator.next();
                    return J9ObjectPointer.cast(next);
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public VoidPointer nextAddress() {
                if (this.hasNext()) {
                    return VoidPointer.cast(this.hashTableIterator.nextAddress());
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The image is read only and cannot be modified.");
            }
        };
    }

    public SlotIterator<J9ObjectPointer> cacheIterator() {
        return new SlotIterator<J9ObjectPointer>(){
            private UDATA cacheTableIndex = new UDATA(0L);
            private UDATA cacheSize;
            private PointerPointer cache;
            {
                try {
                    this.cacheSize = StringTable.this.getCacheSize();
                    this.cache = StringTable.this._stringTable._cacheEA();
                }
                catch (CorruptDataException e) {
                    EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                    this.cacheSize = new UDATA(0L);
                }
            }

            @Override
            public boolean hasNext() {
                while (this.cacheTableIndex.lt(this.cacheSize)) {
                    try {
                        if (this.cache.at(this.cacheTableIndex).notNull()) {
                            return true;
                        }
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                    }
                    this.cacheTableIndex = this.cacheTableIndex.add(1L);
                }
                return false;
            }

            @Override
            public J9ObjectPointer next() {
                if (this.hasNext()) {
                    try {
                        J9ObjectPointer cachedString = J9ObjectPointer.cast(this.cache.at(this.cacheTableIndex));
                        this.cacheTableIndex = this.cacheTableIndex.add(1L);
                        return cachedString;
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                        return null;
                    }
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public VoidPointer nextAddress() {
                if (this.hasNext()) {
                    VoidPointer address = VoidPointer.cast(this.cache.add(this.cacheTableIndex));
                    this.cacheTableIndex = this.cacheTableIndex.add(1L);
                    return address;
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The image is read only and cannot be modified.");
            }
        };
    }

    private UDATA getTableIndex(UDATA hash) throws CorruptDataException {
        return hash.mod(this._stringTable._tableCount());
    }

    private J9HashTablePointer getTable(UDATA tableIndex) throws CorruptDataException {
        J9HashTablePointer hashTablePtr = J9HashTablePointer.cast(this._stringTable._table().at(tableIndex));
        return hashTablePtr;
    }

    public J9ObjectPointer search(J9ObjectPointer objectPointer) throws CorruptDataException {
        UDATA hashCode = this._hashFn.hash(PointerPointer.cast(objectPointer));
        UDATA tableIndex = this.getTableIndex(hashCode);
        J9HashTablePointer hashTablePtr = this.getTable(tableIndex);
        HashTable<J9ObjectPointer> currentHashTable = HashTable.fromJ9HashTable(hashTablePtr, false, J9ObjectPointer.class, new StringHashFunction(), new StringComparatorFunction());
        J9ObjectPointer result = currentHashTable.find(objectPointer);
        return result;
    }

    protected UDATA getCacheSize() {
        return new UDATA(MM_StringTable.cacheSize);
    }

    public static class StringHashFunction<StructType extends AbstractPointer>
    implements HashTable.HashFunction<StructType> {
        @Override
        public UDATA hash(StructType entry) {
            try {
                J9ObjectPointer entryObject = J9ObjectPointer.cast(entry);
                String stringValue = J9ObjectHelper.stringValue(entryObject);
                U32 hashCode = new U32(stringValue.hashCode());
                return new UDATA(hashCode);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error calculating hash", e, false);
                return new UDATA(0L);
            }
        }
    }

    public static class StringComparatorFunction<StructType extends AbstractPointer>
    implements HashTable.HashComparatorFunction<StructType> {
        @Override
        public int compare(StructType o1, StructType o2) throws CorruptDataException {
            J9ObjectPointer leftObject = J9ObjectPointer.cast(o1);
            J9ObjectPointer rightObject = J9ObjectPointer.cast(o2);
            String leftString = J9ObjectHelper.stringValue(leftObject);
            String rightString = J9ObjectHelper.stringValue(rightObject);
            return leftString.compareTo(rightString);
        }
    }

    public static class StringEqualFunction<StructType extends AbstractPointer>
    implements HashTable.HashEqualFunction<StructType> {
        @Override
        public boolean equal(StructType left, StructType right) {
            try {
                J9ObjectPointer leftObject = J9ObjectPointer.cast(left);
                J9ObjectPointer rightObject = J9ObjectPointer.cast(right);
                String leftString = J9ObjectHelper.stringValue(leftObject);
                String rightString = J9ObjectHelper.stringValue(rightObject);
                return leftString.equals(rightString);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error checking equality", e, true);
                return false;
            }
        }
    }
}

