/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm28.j9.DataType;
import com.ibm.j9ddr.vm28.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm28.pointer.U32Pointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9RAMClassRefPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9RAMConstantPoolItemPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm28.structure.J9ConstantPool;
import com.ibm.j9ddr.vm28.types.U32;
import java.util.Iterator;

public final class VMConstantPool {
    private static Object[] _constantPool = null;
    private static U32Pointer _cpShapeDescription;
    private static J9ROMConstantPoolItemPointer _romCPStart;
    private static J9RAMConstantPoolItemPointer _ramCPStart;

    public static J9ClassPointer getClass(long index) throws CorruptDataException {
        if ((long)_constantPool.length <= index || 0L > index) {
            throw new IndexOutOfBoundsException("Index outside of constant pool bounds");
        }
        int cpIndex = (int)index;
        long shapeDesc = ConstantPoolHelpers.J9_CP_TYPE(_cpShapeDescription, cpIndex);
        if (J9ConstantPool.J9CPTYPE_CLASS != shapeDesc) {
            throw new CorruptDataException("VMConstantPool[" + index + "] CP_TYPE is not J9CPTYPE_CLASS");
        }
        J9ClassPointer classPointer = null;
        if (null != _constantPool[cpIndex]) {
            classPointer = (J9ClassPointer)_constantPool[cpIndex];
        } else {
            J9RAMConstantPoolItemPointer ramEntry = _ramCPStart.add(index);
            classPointer = J9RAMClassRefPointer.cast(ramEntry).value();
            VMConstantPool._constantPool[cpIndex] = classPointer;
        }
        return classPointer;
    }

    public static J9ObjectFieldOffset getFieldOffset(long index) throws CorruptDataException {
        if ((long)_constantPool.length <= index || 0L > index) {
            throw new IndexOutOfBoundsException("Index outside of constant pool bounds");
        }
        int cpIndex = (int)index;
        long shapeDesc = ConstantPoolHelpers.J9_CP_TYPE(_cpShapeDescription, cpIndex);
        if (J9ConstantPool.J9CPTYPE_FIELD != shapeDesc) {
            throw new CorruptDataException("VMConstantPool[" + index + "] CP_TYPE is not J9CPTYPE_FIELD");
        }
        J9ObjectFieldOffset offset = null;
        if (null != _constantPool[cpIndex]) {
            offset = (J9ObjectFieldOffset)_constantPool[cpIndex];
        } else {
            J9ROMFieldRefPointer romRef = J9ROMFieldRefPointer.cast(_romCPStart.add(cpIndex));
            J9ClassPointer refClass = VMConstantPool.getClass(romRef.classRefCPIndex().longValue());
            J9ClassPointer currentClass = refClass;
            if (currentClass.notNull()) {
                String fieldName = J9UTF8Helper.stringValue(romRef.nameAndSignature().name());
                String signature = J9UTF8Helper.stringValue(romRef.nameAndSignature().signature());
                while (currentClass.notNull() && null == offset) {
                    Iterator<J9ObjectFieldOffset> fields = J9ClassHelper.getFieldOffsets(currentClass);
                    while (fields.hasNext()) {
                        J9ObjectFieldOffset field = fields.next();
                        if (!field.getName().equals(fieldName) || !field.getSignature().equals(signature)) continue;
                        offset = field;
                        break;
                    }
                    currentClass = J9ClassHelper.superclass(currentClass);
                }
                if (null == offset) {
                    throw new CorruptDataException("VMConstantPool[" + index + "] field not found: " + J9ClassHelper.getName(refClass) + "." + fieldName + " " + signature);
                }
                VMConstantPool._constantPool[cpIndex] = offset;
            }
        }
        return offset;
    }

    static {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9ConstantPoolPointer jclConstantPool = J9ConstantPoolPointer.cast(vm.jclConstantPoolEA());
            J9ClassPointer ramClass = jclConstantPool.ramClass();
            J9ROMClassPointer romClass = ramClass.romClass();
            if (romClass.romConstantPoolCount().gte(new U32(Integer.MAX_VALUE))) {
                throw new CorruptDataException("ROM constantpoolcount exceeds Integer.MAX_VALUE");
            }
            int constPoolCount = romClass.romConstantPoolCount().intValue();
            _constantPool = new Object[constPoolCount];
            _cpShapeDescription = romClass.cpShapeDescription();
            _romCPStart = J9ROMClassHelper.constantPool(romClass);
            _ramCPStart = J9RAMConstantPoolItemPointer.cast(jclConstantPool);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Problem reading the VMConstantPool", e, false);
        }
    }
}

