/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.structure.UtArchitecture;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=UtArchitecture.class)
public class UtArchitecturePointer
extends StructurePointer {
    public static final UtArchitecturePointer NULL = new UtArchitecturePointer(0L);

    protected UtArchitecturePointer(long address) {
        super(address);
    }

    public static UtArchitecturePointer cast(AbstractPointer structure) {
        return UtArchitecturePointer.cast(structure.getAddress());
    }

    public static UtArchitecturePointer cast(UDATA udata) {
        return UtArchitecturePointer.cast(udata.longValue());
    }

    public static UtArchitecturePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new UtArchitecturePointer(address);
    }

    @Override
    public UtArchitecturePointer add(long count) {
        return UtArchitecturePointer.cast(this.address + UtArchitecture.SIZEOF * count);
    }

    @Override
    public UtArchitecturePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public UtArchitecturePointer addOffset(long offset) {
        return UtArchitecturePointer.cast(this.address + offset);
    }

    @Override
    public UtArchitecturePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public UtArchitecturePointer sub(long count) {
        return UtArchitecturePointer.cast(this.address - UtArchitecture.SIZEOF * count);
    }

    @Override
    public UtArchitecturePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public UtArchitecturePointer subOffset(long offset) {
        return UtArchitecturePointer.cast(this.address - offset);
    }

    @Override
    public UtArchitecturePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public UtArchitecturePointer untag(long mask) {
        return UtArchitecturePointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public UtArchitecturePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return UtArchitecture.SIZEOF;
    }
}

