/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.util.HashMap;
import java.util.Iterator;

public class J9ClassLoaderHelper {
    private static HashMap<Character, J9ClassPointer> PRIMITIVE_TO_CLASS;

    public static J9ClassPointer findClass(J9ClassLoaderPointer classLoader, String signature) throws CorruptDataException {
        J9ClassPointer clazz;
        J9ClassPointer result = null;
        Iterator<J9ClassPointer> classIterator = ClassIterator.fromJ9Classloader(classLoader);
        int arity = J9ClassLoaderHelper.calculateClassArity(signature);
        if (arity > 0 && !J9ClassHelper.isRefOrValSignature(signature.charAt(arity))) {
            return PRIMITIVE_TO_CLASS.get(Character.valueOf(signature.charAt(arity)));
        }
        while (classIterator.hasNext() && null == (result = J9ClassLoaderHelper.match(signature, arity, clazz = classIterator.next()))) {
        }
        return result;
    }

    private static J9ClassPointer match(String searchSignature, int arity, J9ClassPointer clazz) throws CorruptDataException {
        String classSignature = J9ClassHelper.getSignature(clazz);
        J9ClassPointer result = null;
        if (J9ClassLoaderHelper.matchLeafComponentType(searchSignature, arity, classSignature)) {
            result = J9ClassLoaderHelper.getArrayClassWithArity(clazz, arity);
        }
        return result;
    }

    private static J9ClassPointer getArrayClassWithArity(J9ClassPointer clazz, int arity) throws CorruptDataException {
        J9ClassPointer result = clazz;
        for (int i = 0; i < arity; ++i) {
            if (!(result = result.arrayClass()).isNull()) continue;
            return null;
        }
        return result;
    }

    private static boolean matchLeafComponentType(String searchSignature, int arity, String classSignature) {
        return classSignature.regionMatches(0, searchSignature, arity, searchSignature.length() - arity);
    }

    private static int calculateClassArity(String signature) {
        int arity = signature.lastIndexOf(91);
        return arity + 1;
    }

    static {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            PRIMITIVE_TO_CLASS = new HashMap();
            PRIMITIVE_TO_CLASS.put(Character.valueOf('V'), vm.voidReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('Z'), vm.booleanReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('B'), vm.byteReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('C'), vm.charReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('S'), vm.shortReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('I'), vm.intReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('J'), vm.longReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('F'), vm.floatReflectClass());
            PRIMITIVE_TO_CLASS.put(Character.valueOf('D'), vm.doubleReflectClass());
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corrupt VM pointer", e, true);
        }
    }
}

